<?php

namespace DirectoristDigitalMarketplace\Module\WooCommerce;

use DirectoristDigitalMarketplace\Module\WooCommerce\Model\Product as Product_Data;
use DirectoristDigitalMarketplace\Helper\Listing as Listing;
use DirectoristDigitalMarketplace\Global_Helpers as Global_Helpers;
class Product {

	/**
	 * Constuctor
	 * 
	 */
	function __construct() {
		add_action( 'edit_post', [ $this, 'add_product_on_listing_published' ], 10, 2 );
		add_filter( 'atbdp_listing_form_submission_info', [ $this, 'add_product_on_listing_published_from_frontend' ] );

	}


	public function add_product_on_listing_published_from_frontend( $args ) {
		$listing_id = ! empty( $args['id'] ) ? directorist_clean( $args['id'] ) : '';
		$this->add_product( $listing_id );
		return $args;
	}

	/**
	 * Updates listing.
	 *
	 * @param int    $listing_id Listing ID.
	 * @param object $listing Listing object.
	 */

	public function add_product_on_listing_published( $listing_id, $listing ) {

		if( get_post_type( $listing ) !== ATBDP_POST_TYPE ) {
			return;
		}

		if( ! is_admin() ) {
			return;
		}

		$this->add_product( $listing_id );
	}

	public function add_product( $listing_id ) {

		if( ! $listing_id ) {
			return;
		}
		$listing = get_post( $listing_id );
		$is_salable = Listing::is_sellable( $listing_id );

		
		if( ! $is_salable ) {
			return;
		}

		// Get product.
		$product = Product_Data::get_related( $listing_id );
		
		if ( ! $product ) {

			$directory_type = get_post_meta( $listing_id, '_directory_type', true );
			$new_l_status   = get_term_meta( $directory_type, 'new_listing_status', true );
			
			if ( ( get_post_status( $listing_id ) === 'publish' ) || ( 'publish' === $new_l_status ) ) {
				
				// Add product.
				$product = new \WC_Product();
				
				// Set properties.
				$product->set_props(
					[
						'parent_id'          => $listing_id,
						'catalog_visibility' => 'hidden',
						'virtual'            => true,
					]
				);
			} else {
				return;
			}
		}

		$price = Listing::get_price( $listing_id );
		if ( Listing::get_price_tiers( $listing_id ) ) {

			// Get tier.
			$tier	= Global_Helpers\ddm_get_first_array_value( Listing::get_price_tiers( $listing_id ) );
			$price	= ! empty( $tier['price'] ) ? $tier['price'] : $price;
			
		}
		
		// Set product properties.
		$product->set_props(
			[
				'name'          => $listing->post_title,
				'slug'          => $listing->post_name,
				'status'        => $listing->post_status,
				'date_created'  => $listing->post_date,
				'date_modified' => $listing->post_modified,
				'price'         => $price,
				'regular_price' => $price,
			]
		);

		//@todo new options
		if ( 'allow_quentity' ) {
			$quantity = ! empty( Listing::get_quantity( $listing_id ) ) ? Listing::get_quantity( $listing_id ) : 1;
			$product->set_props(
				[
					'manage_stock'   => true,
					'stock_quantity' => $quantity,
				]
			);
		}

		//@todo new option
		if ( 'listing_need_attatchment' ) {

			$files_url = (array) Listing::downloadable_attatchments( $listing_id );
		
			if ( $files_url ) {

				// Get downloads.
				$downloads = [];

				foreach ( $files_url as $key => $url ) {

					$url = substr($url, 0, -3);
					// Get attachment URL and name.
					$attachment_name = preg_replace( '/-[a-z0-9]{6}\./', '.', wp_basename( $url ) );

					// Add download.
					$downloads[] = [
						'download_id' => md5( $listing_id . '-' . $key ),
						'name'        => $attachment_name,
						'file'        => $url,
					];
				}

				// Set download properties.
				$product->set_props(
					[
						'downloadable' => true,
						'downloads'    => $downloads,
					]
				);
			}
		}
		// Update product.
		if ( $product->save() ) {

			// Set user.
			wp_update_post(
				[
					'ID'          => $product->get_id(),
					'post_status' => 'publish',
					'post_author' => Listing::user__id( $listing_id ),
				]
			);
		
		}
	}
}