<?php

namespace DirectoristDigitalMarketplace\Module\Dashboard;

use WP_Query;
use DirectoristDigitalMarketplace\Global_Helpers as Global_Helpers;
use DirectoristDigitalMarketplace\Module\WooCommerce\WC_Helper;
class Tabs_Wallet {

	/**
	 * Constuctor
	 * 
	 */
	function __construct() {
        add_action( 'directorist_after_dashboard_navigation', [ $this, 'non_legacy_add_dashboard_nav_link' ] );
        add_action( 'directorist_after_dashboard_contents', [ $this, 'non_legacy_add_dashboard_nav_content' ] );
	
	}

	public function non_legacy_add_dashboard_nav_link() {
        $html = '<li class="directorist-tab__nav__item"><a href="" class="directorist-booking-nav-link directorist-tab__nav__link" id="my_wallet_tab" target="my_wallet"><span class="directorist_menuItem-text"><span class="directorist_menuItem-icon">'. directorist_icon( 'las la-wallet', false ) .'</span>' . esc_html__('My Wallet', 'directorist-booking') . '</span></a></li>';
        echo apply_filters('atbdp_user_dashboard_wallet_tab', $html);
    }

    public function non_legacy_add_dashboard_nav_content() {
        
        $user_id    = get_current_user_id();     
        $total_earning = Global_Helpers\get_vendor_orders( $user_id );
        $total      = 0;
        if( ! empty( $total_earning ) ) {
            foreach( $total_earning as $order ) {
                $order = wc_get_order( $order );
                $total += $order->get_total();
            }
        }

        $orders_can_withdraw['meta_query'] = [
            'relation' => 'AND',
            [
                'key'     => 'ddm_vendor',
                'value'   => $user_id,
                'compare' => '=',
            ],
            [
                'key'     => '_ddm_paid_payout',
                'compare' => 'NOT EXISTS',
            ],
        ];
        $orders_can_withdraw['post_status'] = 'wc-completed';

        $available_earning = Global_Helpers\get_vendor_orders( $user_id, $orders_can_withdraw );  
        WC_Helper::update_vendor_balance_by_orders( $user_id, $available_earning );        
        
        $payouts = Global_Helpers\get_payouts( $user_id, 'publish' );

        $args = [
            'commission_rate' => get_directorist_option( 'vendor_commission_rate', 10 ),
            'payout_minimum' => get_directorist_option( 'payout_minimum', 5 ),
            'available_payout_amount' => get_user_meta( $user_id, '_ddm_available_payout', true ),
            'total_sold' => $total,
            'orders' => $total_earning,
            'payouts' => $payouts,
            'payout_methods' => get_terms([ 'taxonomy' => 'ddm_payout_method', 'hide_empty' => false, ]),
            'method_details' => get_user_meta( $user_id, '_payout_methods', true ),
        ];
        ?>
        <div <?php echo apply_filters( 'wallet_dashboard_content_div_attributes', 'class="directorist-tab__pane" id="my_wallet"' ); ?>>
            <?php
	        Global_Helpers\get_template( 'dashboard/wallet', $args );
            ?>
        </div>
        <?php

    }
}