<?php

namespace DirectoristDigitalMarketplace\Module\Dashboard;

use WP_Query;
use DirectoristDigitalMarketplace\Global_Helpers as Global_Helpers;
use DirectoristDigitalMarketplace\Module\WooCommerce\WC_Helper;
class Tabs_Downloads {

	/**
	 * Constuctor
	 * 
	 */
	function __construct() {
        add_action( 'directorist_after_dashboard_navigation', [ $this, 'non_legacy_add_dashboard_nav_link' ] );
        add_action( 'directorist_after_dashboard_contents', [ $this, 'non_legacy_add_dashboard_nav_content' ] );
	
	}

	public function non_legacy_add_dashboard_nav_link() {
        $html = '<li class="directorist-tab__nav__item"><a href="" class="directorist-tab__nav__link" id="my_download_tab" target="my_downloads"><span class="directorist_menuItem-text"><span class="directorist_menuItem-icon">'. directorist_icon( 'las la-download', false ) .'</span>' . esc_html__('My Downloads', 'directorist-booking') . '</span></a></li>';
        echo apply_filters('atbdp_user_dashboard_wallet_tab', $html);
    }

    public function non_legacy_add_dashboard_nav_content() {
        

        $downloads = WC()->customer->get_downloadable_products();

        $args = [
            'downloads' => $downloads,
        ];
        ?>
        <div class="directorist-tab__pane" id="my_downloads">
            <?php
	        Global_Helpers\get_template( 'dashboard/downloads', $args );
            ?>
        </div>
        <?php

    }
}