<?php
namespace DirectoristDigitalMarketplace\Module\Dashboard;
use DirectoristDigitalMarketplace\Global_Helpers as Global_Helpers;

class Payouts
{
    public function __construct()
    {
        if( ! class_exists( 'BD_Booking' ) ) {
            add_action( 'init', array( $this, 'register') );
            //Commission columns
            add_filter( 'manage_ddm_commission_posts_columns', array( $this, 'ddm_commission_add_new_plan_columns' ) );
            add_action( 'manage_ddm_commission_posts_custom_column', array( $this, 'ddm_commission_column_content' ), 10, 2 );
            //Payout columns
            add_filter( 'manage_ddm_payout_posts_columns', array( $this, 'ddm_payout_add_new_plan_columns' ) );
            add_action( 'manage_ddm_payout_posts_custom_column', array( $this, 'ddm_payout_column_content' ), 10, 2 );
            //create meta boxes
            // add_action( 'add_meta_boxes', array( $this, 'create_meta_box_for_commission' ) );
            // add_action( 'admin_footer-edit.php', array( $this, 'admin_footer_edit' ) );
            // add_action( 'load-edit.php', array( $this, 'load_edit' ) );
        }
        add_filter( 'gettext', array( $this, 'change_publish_button_text' ), 10, 2 );
        add_filter( 'post_row_actions', array( $this, 'post_row_actions' ), 10, 2 );
        add_action('post_submitbox_misc_actions', array($this, 'post_submitbox_meta'));

        add_action( 'pending_to_publish', [ $this, 'update_payout' ] );
        add_action( 'edit_post', [ $this, 'save_metas' ], 10, 2 );


    }

    public function save_metas( $post_id, $post ) {
        if( 'ddm_payout' !== $post->post_type ) {
            return;
        }
        $payout_amount = ! empty( $_POST['payout'] ) ? directorist_clean( wp_unslash( $_POST['payout'] ) ) : '';
        update_post_meta( $post_id, '_amount', $payout_amount );
    }

    public function post_submitbox_meta( $post ) {
        if( 'ddm_payout' !== $post->post_type ) {
            return;
        }
        $payout = get_post_meta( $post->ID, '_amount', true );
        ?>
        <div class="ddm_payout_amount">
            <label for="ddm_payout"><?php directorist_icon( 'las la-dollar-sign' );?><?php esc_html_e( 'Payout Amount', 'directorist-digital-download' ); ?></label>
            <input type="number" name="payout" id="ddm_payout" value="<?php echo esc_attr( $payout ); ?>">
        </div>
        <?php
    }

    public function post_row_actions( $actions, $post ) {
        if( ! $post ) {
            return;
        }
        if( $post->post_type === 'ddm_commission' ) {
            unset( $actions['edit'] );
            unset( $actions['view'] );
            unset( $actions['inline hide-if-no-js'] );

            return $actions;
        }

        if( $post->post_type === 'ddm_payout' ) {
            unset( $actions['view'] );
            unset( $actions['inline hide-if-no-js'] );
            return $actions;
        }

        return $actions;
    }

    public function update_payout( $post ) {
        if( ! $post ) {
			return;
		}

		if( 'ddm_payout' !== get_post_type( $post ) ) {
			return;
		}
        // update user payout balance
        $user_id = $post->post_author;
        update_user_meta( $user_id, '_ddm_available_payout', 0 );

        
        // mark orders as paid
        // $args = [];
        $args['meta_query'] = [
            'relation' => 'AND',
            [
                'key'     => 'ddm_vendor',
                'value'   => $user_id,
                'compare' => '=',
            ],
            [
                'key'     => '_ddm_paid_payout',
                'compare' => 'NOT EXISTS',
            ],
        ];

        $orders = Global_Helpers\get_vendor_orders( $user_id, $args );
     
        if( ! empty( $orders ) ) {
            foreach( $orders as $order ) {
            $order = wc_get_order( $order );
            $order->update_meta_data( '_ddm_paid_payout', true );
            $order->save();
            //update admin commission status
            $this->update_admin_commission( $order );
            }
        }

    }

    public function update_admin_commission( $order_id ) {
        $commissions = get_posts([
            'post_type' => 'ddm_commission',
            'fields' => 'ids',
            'meta_key' => '_order',
            'meta_value' => $order_id,
            'meta_compare' => '=',
        ]);
        if( ! empty( $commissions ) ) {
            foreach( $commissions as $commission ) {
                wp_update_post( [ 'ID' => $commission ] );
            }
        }
    }

    public function change_publish_button_text( $translation, $text ) {

        global $post_type;

        if( 'ddm_payout' === $post_type ) {
            if ( $text == 'Publish' ) {
                return 'Mark as Paid';
            }
        }
        return $translation;
    }

    //custom post type for register
    public function register() {
        $labels = array(
            'name'                  => _x( 'All Commissions', 'Post type general name', 'directorist-booking' ),
            'singular_name'         => _x( 'Commission', 'Post type singular name', 'directorist-booking' ),
            'menu_name'             => _x( 'Commissions', 'Admin Menu text', 'directorist-booking' ),
            'name_admin_bar'        => _x( 'Commission', 'Add New on Toolbar', 'directorist-booking' ),
            'new_item'              => __( 'New Commission', 'directorist-booking' ),
            'edit_item'             => __( 'Edit Commission', 'directorist-booking' ),
            'view_item'             => __( 'View Commission', 'directorist-booking' ),
            'all_items'             => __( 'All Commissions', 'directorist-booking' ),
            'search_items'          => __( 'Search Commissions', 'directorist-booking' ),
            'parent_item_colon'     => __( 'Parent Commissions:', 'directorist-booking' ),
            'not_found'             => __( 'No Commissions found.', 'directorist-booking' ),
            'not_found_in_trash'    => __( 'No Commissions found in Trash.', 'directorist-booking' ),
        );

        $args = array(
            'labels'             => $labels,
            'supports'           => array( 'title', 'editor' ),
            'public'             => true,
            'publicly_queryable' => true,
            'show_ui'            => true,
            'show_in_menu'       => true,
            'query_var'          => true,
            'taxonomies'         => array( 'ddm_payout_method' ),
            'rewrite'            => array( 'slug' => 'commission' ),
            'capabilities' => array(
                'create_posts'   => 'do_not_allow',
            ),
            'menu_icon' => 'dashicons-money-alt',
            'has_archive'        => true,
            'hierarchical'       => false,
            'menu_position'      => null,
            'show_in_nav_menus' => true,
            'can_export' => true,
            'exclude_from_search' => true,
            //'capability_type' => 'at_biz_dir',
            'map_meta_cap' => true,
        );

        $labels_two = array(
            'name'                  => _x( 'Payouts', 'Post type general name', 'directorist-booking' ),
            'singular_name'         => _x( 'Payout', 'Post type singular name', 'directorist-booking' ),
            'menu_name'             => _x( 'Payouts', 'Admin Menu text', 'directorist-booking' ),
            'name_admin_bar'        => _x( 'Payouts', 'Add New on Toolbar', 'directorist-booking' ),
            'new_item'              => __( 'New Payouts', 'directorist-booking' ),
            'edit_item'             => __( 'Edit Payouts', 'directorist-booking' ),
            'view_item'             => __( 'View Payouts', 'directorist-booking' ),
            'all_items'             => __( 'Payouts', 'directorist-booking' ),
            'search_items'          => __( 'Search Payouts', 'directorist-booking' ),
            'parent_item_colon'     => __( 'Parent Payouts:', 'directorist-booking' ),
            'not_found'             => __( 'No Payout found.', 'directorist-booking' ),
            'not_found_in_trash'    => __( 'No Payouts found in Trash.', 'directorist-booking' ),
        );

        $args_two = array(
            'labels'             => $labels_two,
            'supports'           => array( 'title', 'editor' ),
            'public'             => true,
            'publicly_queryable' => true,
            'show_ui'            => true,
            'show_in_menu'       => 'edit.php?post_type=ddm_commission',
            'query_var'          => true,
            'rewrite'            => array( 'slug' => 'commission' ),
            'capabilities' => array(
                'create_posts'   => 'do_not_allow',
            ),
            'has_archive'        => true,
            'hierarchical'       => false,
            'menu_position'      => null,
            'show_in_nav_menus' => true,
            'can_export' => true,
            'exclude_from_search' => true,
            //'capability_type' => 'at_biz_dir',
            'map_meta_cap' => true,
        );

        $labels = array(
            'name'              => _x( 'Payout Mehods', 'Method general name', 'directorist' ),
            'singular_name'     => _x( 'Method', 'Method singular name', 'directorist' ),
            'search_items'      => __( 'Search Method', 'directorist' ),
            'all_items'         => __( 'All Payout Mehods', 'directorist' ),
            'parent_item'       => __( 'Parent Method', 'directorist' ),
            'parent_item_colon' => __( 'Parent Method:', 'directorist' ),
            'edit_item'         => __( 'Edit Method', 'directorist' ),
            'update_item'       => __( 'Update Method', 'directorist' ),
            'add_new_item'      => __( 'Add New Method', 'directorist' ),
            'new_item_name'     => __( 'New Method Name', 'directorist' ),
            'menu_name'         => __( 'Payout Mehods', 'directorist' ),
        );

        $method_args = array(
            'hierarchical'      => true,
            'show_in_rest'      => true,
            'labels'            => $labels,
            'show_ui'           => true,
            'show_admin_column' => true,
            'query_var'         => true,
            'public'            => true,
            'show_in_nav_menus' => true,
        );

        register_post_type( 'ddm_commission', $args );
        register_post_type( 'ddm_payout', $args_two );
        register_taxonomy( 'ddm_payout_method', 'ddm_commission', $method_args );


    }

    public function ddm_commission_add_new_plan_columns() {
        $columns = array(
            'cb'                => '<input type="checkbox" />', // Render a checkbox instead of text
            'user_name'         => __('User Name', 'directorist'),
            'balance_pay'       => __('Balance to Pay', 'directorist'),
            'my_earning'        => __('My Earnings', 'directorist'),
            'date'              => __('Date', 'directorist'),
        );

        return $columns;
    }

    public function ddm_commission_column_content( $column, $post_id ) {
        echo '</select>';
        switch ( $column ) {
            case 'user_name' :
                echo esc_html( get_the_title( $post_id ) );
                break;
            case 'balance_pay' :
                $total = get_post_meta( $post_id, '_amount', true );
                $earning = get_post_meta( $post_id, '_earning', true );
                $total_balance_pay = $total - $earning;
                echo atbdp_display_price( $total_balance_pay );
                break;
            case 'my_earning' :
                $earning = get_post_meta( $post_id, '_earning', true );
                echo atbdp_display_price( $earning );
                break;
            case 'date' :
                $t           = get_the_time('U');
                $date_format = get_option('date_format');
                echo date_i18n($date_format, $t);
                break;

        }
    }

    public function ddm_payout_add_new_plan_columns() {
        $columns = array(
            'cb'                => '<input type="checkbox" />', // Render a checkbox instead of text
            'user_name'         => __('User Name', 'directorist-booking'),
            'payment_status'    => __('Payment Status', 'directorist'),
            'amount'            => __('Amount', 'directorist-booking'),
            'payment_method'    => __('Payment Method', 'directorist-booking'),
            'bdb_date'          => __('Date', 'directorist-booking'),
        );

        return $columns;
    }

    public function ddm_payout_column_content( $column, $post_id ) {
        echo '</select>';
        switch ( $column ) {
            case 'user_name' :
                $author_id = get_post_field( 'post_author', $post_id );
                $username = get_the_author_meta( 'display_name' , $author_id );
                printf('<p><a href="%s"> %s</a></p>', get_edit_post_link( $post_id ), $username );
                break;
            case 'payment_status' :
                $status = get_post_status( $post_id );
                echo 'publish' === $status ? esc_html__( 'Paid', 'directorist-digital-marketplace' ) : esc_attr( ucfirst( $status ) );
                break;
            case 'amount' :
                $amount = get_post_meta( $post_id, '_amount', true );
                echo atbdp_display_price( $amount ) ;
                break;
            case 'payment_method' :
                $method = get_post_meta( $post_id, '_method', true );
                $term = get_term_by( 'slug', $method, 'ddm_payout_method' );
                echo ! is_wp_error( $term ) ? $term->name : '' ;
                break;
            case 'bdb_date' :
                $t           = get_the_time('U');
                $date_format = get_option('date_format');
                echo date_i18n($date_format, $t);
                break;
        }
    }

    public function create_meta_box_for_commission() {
        add_meta_box( 'dbb_commission_details', __('Details', 'directorist-booking'), array( $this, 'commission_details_meta_box' ), 'ddm_commission', 'normal', 'high' );
    }

    public function commission_details_meta_box( $post ) {
        // Add a nonce field so we can check for it later
        wp_nonce_field('atbdp_review_save_details', 'atbdp_review_details_nonce');
        wp_enqueue_style('bdb-admin-css');
        $post_meta           = get_post_meta( $post->ID ) ? get_post_meta( $post->ID ) : '' ;
        $listing_name        = isset( $post_meta['_listing_name'] ) ? esc_attr( $post_meta['_listing_name'][0] ) : '';
        $publish_date        = isset( $post_meta['_publish_date'] ) ? esc_attr( $post_meta['_publish_date'][0] ) : '';
        $order_id            = isset( $post_meta['_order_id'] ) ? esc_attr( $post_meta['_order_id'][0] ) : '';
        $username            = isset( $post_meta['_username'] ) ? esc_attr( $post_meta['_username'][0] ) : '';
        $amount              = isset( $post_meta['_amount'] ) ? esc_attr( $post_meta['_amount'][0] ) : '';
        $site_fee            = isset( $post_meta['_site_fee'] ) ? esc_attr( $post_meta['_site_fee'][0] ) : '';
        $balance_pay         = isset( $post_meta['_balance_pay'] ) ? esc_attr( $post_meta['_balance_pay'][0] ) : '';
        $total_balance_pay   = isset( $post_meta['_total_balance_pay'] ) ? esc_attr( $post_meta['_total_balance_pay'][0] ) : '';
        $get_user        = get_user_by( 'slug', $username);
        $user_id         = $get_user->ID;
        $payment_method  = get_user_meta( $user_id, 'bdb_payment_method', true );
        $payment_details = get_user_meta( $user_id, 'bdb_payment_details', true );
        $payment_method  = !empty( $payment_method ) ? esc_attr( $payment_method ) : __( 'No Payment Method', 'directorist-booking' );
        $paypal_email    = get_user_meta( $user_id, 'bdb_paypal_email', true );
        $bank_details    = get_user_meta( $user_id, 'bdb_bank_details', true );
        $other_details   = get_user_meta( $user_id, 'bdb_other_details', true );
        if( 'paypal' == $payment_method ) {
            $payment_method = 'PayPal';
        } elseif( 'bank_transfer' == $payment_method ) {
            $payment_method = 'Bank Transfer';
        } elseif( 'bdb_other' == $payment_method ) {
            $payment_method = 'Other';
        }
        if( 'PayPal' == $payment_method ) {
            $payment_details   = ! empty( $paypal_email ) ? esc_attr( $paypal_email )  : '';
        } elseif( 'Bank Transfer' == $payment_method ) {
            $payment_details   = ! empty( $bank_details ) ? esc_attr( $bank_details )  : '';
        } elseif( 'Other' == $payment_method ) {
            $payment_details   = ! empty( $other_details ) ? esc_attr( $other_details )  : '';
        }
        $listing_names       = unserialize( base64_decode( $listing_name ) );
        $publish_date        = unserialize( base64_decode( $publish_date ) );
        $order_id            = unserialize( base64_decode( $order_id     ) );
        $amount              = unserialize( base64_decode( $amount ) );
        $site_fee            = unserialize( base64_decode( $site_fee ) );
        $balance_pay         = unserialize( base64_decode( $balance_pay ) );
        $commissions         = [];
        foreach ( $listing_names as $index => $name ) {
            $commissions[] = [
                'listing_name'  => $name,
                'date'          => $publish_date[ $index ],
                'order_id'      => $order_id[ $index ],
                'amount'        => $amount[ $index ],
                'site_fee'      => $site_fee[ $index ],
                'balance_pay'   => $balance_pay[ $index ],
            ];
        }
        ?>
        <ul class="atbd-commission-details">
            <li><span class="atbd-commission-details__label"><?php _e( 'Payment for', 'directorist-booking' ); ?></span> : <?php echo ! empty( $username ) ? esc_attr( $username ) : ''; ?></li>
            <li><span class="atbd-commission-details__label"><?php _e( 'Payment Amount', 'directorist-booking' ); ?></span> : <?php echo ! empty( $total_balance_pay ) ? atbdp_display_price( esc_attr( $total_balance_pay ), false,  '', '', '', false ) : ''; ?></li>
            <li><span class="atbd-commission-details__label"><?php _e( 'Payment Method', 'directorist-booking' ); ?></span> : <?php echo ! empty( $payment_method ) ? esc_attr( $payment_method ) : ''; ?></li>
            <li><span class="atbd-commission-details__label"><?php _e( 'Payment Details', 'directorist-booking' ); ?></span> : <?php echo ! empty( $payment_details ) ? esc_textarea( $payment_details ) : ''; ?></li>
        </ul>
        <div class="directorist-table-responsive">
            <table class="atbd-commission-table">
                <thead>
                    <tr>
                        <th><?php _e( 'Listing Name', 'directorist-booking' );?></th>
                        <th><?php _e( 'Total Order value', 'directorist-booking' );?></th>
                        <th><?php _e( 'Site Fee', 'directorist-booking' );?></th>
                        <th><?php _e( 'User Earning', 'directorist-booking' );?></th>
                        <th><?php _e( 'Order ID', 'directorist-booking' );?></th>
                        <th><?php _e( 'Date', 'directorist-booking' );?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    foreach( array_reverse( $commissions ) as $commission ) :
                    ?>
                    <tr>
                        <td><?php echo !empty( $commission['listing_name'] ) ? $commission['listing_name'] : ''; ?></td>
                        <td><?php echo !empty( $commission['amount'] ) ? atbdp_display_price( $commission['amount'], false,  '', '', '', false ) : ''; ?></td>
                        <td><?php echo !empty( $commission['site_fee'] ) ? atbdp_display_price( $commission['site_fee'], false,  '', '', '', false ) : ''; ?></td>
                        <td><?php echo !empty( $commission['balance_pay'] ) ? atbdp_display_price( $commission['balance_pay'], false,  '', '', '', false ) : ''; ?></td>
                        <td><?php echo !empty( $commission['order_id'] ) ? $commission['order_id'] : ''; ?></td>
                        <td><?php echo !empty( $commission['date'] ) ? $commission['date'] : ''; ?></td>
                    </tr>
                    <?php
                    endforeach;
                    ?>
                </tbody>
            </table>
        </div>
        <?php
    }

    public function admin_footer_edit() {
        global $post_type;
        if ('ddm_commission' == $post_type) {

            ?>
            <script type="text/javascript">
                var atbdp_bulk_actions = <?php echo json_encode( array( 'set_to_payment' => __( "Payment" ) ) ); ?>;

                jQuery(document).ready(function () {
                    for (var key in atbdp_bulk_actions) {
                        if (atbdp_bulk_actions.hasOwnProperty(key)) {
                            var $option = jQuery('<option>').val(key).text(atbdp_bulk_actions[key]);
                            $option.appendTo('#bulk-action-selector-top', '#bulk-action-selector-bottom');
                            //$option.appendTo('#bulk-action-selector-bottom');
                        }
                    }

                    jQuery('select[name="action"]').find('option[value="edit"]').remove();
                    jQuery('select[name="action2"]').find('option[value="edit"]').remove();
                });
            </script>
            <?php
        }
    }

    public function load_edit()
    {
        // Handle the custom bulk action
        global $typenow;
        $post_type = $typenow;

        if ( 'ddm_commission' == $typenow ) {

            // Get the action
            $wp_list_table = _get_list_table('WP_Posts_List_Table');
            $action = $wp_list_table->current_action();

            $allowed_actions = array_keys( array( 'set_to_payment' => __( "Payment" ) ) );
            if (  !in_array( $action, $allowed_actions ) ) return;

            // Security check
            check_admin_referer('bulk-posts');

            // Make sure ids are submitted
            if (isset($_REQUEST['post'])) {
                $post_ids = array_map('intval', $_REQUEST['post']);
            }

            if (empty($post_ids)) return;

            // This is based on wp-admin/edit.php
            $sendback = remove_query_arg(array_merge($allowed_actions, array('untrashed', 'deleted', 'ids')), wp_get_referer());
            if (!$sendback) $sendback = admin_url("edit.php?post_type=$post_type");

            $pagenum = $wp_list_table->get_pagenum();
            $sendback = add_query_arg('paged', $pagenum, $sendback);

            $modified = 0;
            foreach ($post_ids as $post_id) {
                if ( ! $this->update_payment( $action, $post_id ) ) wp_die(__('Error updating post.', 'directorist-booking'));
                $modified++;
            }

        }

    }

    public function update_payment( $action, $post_id ) {
        if( 'set_to_payment' == $action ) {
            $username                    = get_post_meta( $post_id, '_username', true );
            $listing_name                = get_post_meta( $post_id, '_listing_name', true );
            $publish_date                = get_post_meta( $post_id, '_publish_date', true );
            $order_id                    = get_post_meta( $post_id, '_order_id', true );
            $amount                      = get_post_meta( $post_id, '_amount', true );
            $site_fee                    = get_post_meta( $post_id, '_site_fee', true );
            $balance_pay                 = get_post_meta( $post_id, '_balance_pay', true );
            $total_balance_pay           = get_post_meta( $post_id, '_total_balance_pay', true );
            $total                       = get_post_meta( $post_id, '_total', true );
            $order_count                 = get_post_meta( $post_id, '_order_count', true );
            $get_user  = get_user_by( 'slug', $username);
            $user_id   = $get_user->ID;
            $payment_method  = get_user_meta( $user_id , 'bdb_payment_method', true );
            $payment_details = get_user_meta( $user_id , 'bdb_payment_details', true );
            $payment_method  = !empty( $payment_method ) ? esc_attr( $payment_method ) : __( 'No Payment Method', 'directorist-booking' );
            $paypal_email    = get_user_meta( $user_id, 'bdb_paypal_email', true);
            $bank_details    = get_user_meta( $user_id, 'bdb_bank_details', true);
            $other_details   = get_user_meta( $user_id, 'bdb_other_details', true);
            if( 'paypal' == $payment_method ) {
                $payment_method = 'PayPal';
            } elseif( 'bank_transfer' == $payment_method ) {
                $payment_method = 'Bank Transfer';
            } elseif( 'bdb_other' == $payment_method ) {
                $payment_method = 'Other';
            }
            if( 'PayPal' == $payment_method ) {
                $payment_details   = ! empty( $paypal_email ) ? esc_attr( $paypal_email )  : '';
            } elseif( 'Bank Transfer' == $payment_method ) {
                $payment_details   = ! empty( $bank_details ) ? esc_attr( $bank_details )  : '';
            } elseif( 'Other' == $payment_method ) {
                $payment_details   = ! empty( $other_details ) ? esc_attr( $other_details )  : '';
            }

            $payout_id  = wp_insert_post( array(
                'post_content'      => '',
                'post_title'        => $username,
                'post_status'       => 'publish',
                'post_type'         => 'ddm_payout',
                'comment_status'    => false,
            ) );
            update_post_meta( $payout_id, '_username', $username );
            update_post_meta( $payout_id, '_listing_name', $listing_name );
            update_post_meta( $payout_id, '_publish_date', $publish_date );
            update_post_meta( $payout_id, '_order_id', $order_id );
            update_post_meta( $payout_id, '_amount', $amount );
            update_post_meta( $payout_id, '_site_fee', $site_fee );
            update_post_meta( $payout_id, '_balance_pay', $balance_pay );
            update_post_meta( $payout_id, '_total_balance_pay', $total_balance_pay );
            update_post_meta( $payout_id, '_total', $total );
            update_post_meta( $payout_id, '_order_count', $order_count );
            update_post_meta( $payout_id, '_payment_method', $payment_method );
            update_post_meta( $payout_id, '_payment_details', $payment_details );
            wp_delete_post( $post_id );
        }
        return true;
    }
}