<?php

namespace DirectoristDigitalMarketplace\Module\Core\Widget;

use DirectoristDigitalMarketplace\Global_Helpers as Global_Helpers;
use DirectoristDigitalMarketplace\Helper\Listing as Listing;

use WP_Widget;
use ATBDP_Permalink;
use WP_Query;

class DDW_Purchase_Download extends WP_Widget {

	/**
     * Register widget
     */
    public function __construct() {
        $widget_options = array(
            'classname' => 'directorist_widget ddm_widget',
            'description' => __( 'Show Buy Now button for a listing', 'directorist-digital-marketplace' ),
        );
        parent::__construct(
            'ddm_download_widget', // Base ID, must be unique
            __( 'Directorist - Digital Download', 'directorist-digital-marketplace' ), // Name
            $widget_options // Args
        );
    }

    /**
     * Front-end display of widget.
     *
     * @see WP_Widget::widget()
     *
     * @param array $args     Widget arguments.
     * @param array $instance Saved values from database.
     */
    public function widget( $args, $instance ) {

        if( ! is_singular( ATBDP_POST_TYPE ) ) {
            return;
        }
        $has_download = get_post_meta( get_the_ID(), '_digital_download', true );
		if( ! $has_download ) {
			return;
		}
        $fields_data = [
            'price'     => Listing::get_price( get_the_ID() ),
            'tiers' 	=> get_post_meta( get_the_ID(), '_price_tiers', true ),
            'extras' 	=> get_post_meta( get_the_ID(), '_price_extras', true ),
            'hourly' 	=> get_post_meta( get_the_ID(), '_ddm_hourly', true ),
            'monthly' 	=> get_post_meta( get_the_ID(), '_ddm_monthly', true ),
            'quantity' 	=> get_post_meta( get_the_ID(), '_ddm_set_quantity', true ),
            'allow_quantity' => get_post_meta( get_the_ID(), '_ddm_allow_quantity', true ),

        ];
        $args['fields_data'] = $fields_data;

        $title = !empty($instance['title']) ? esc_html($instance['title']) : esc_html__('Title', 'directorist-digital-marketplace');
        echo $args['before_widget'];
        // e_var_dump( $args )
        ?>
        <div class="directorist_widget_title ddm_widget-title">
            <?php echo $args['before_title'] . esc_html( apply_filters( 'widget_submit_item_title', $title ) ) . $args['after_title']; ?>
        </div> 
        <div class="directoirst_widget_body ddm_widget-body">
            <?php
            Global_Helpers\get_template( 'single-listing/form', $args );
            ?>
        </div>
        <?php
        echo $args['after_widget'];        
       
    }

    /**
     * Back-end widget form.
     *
     * @see WP_Widget::form()
     *
     * @param array $instance Previously saved values from database.
     * @return void
     */
    public function form( $instance ) {
        $title = ! empty( $instance['title'] ) ? esc_html($instance['title']) : esc_html__( 'Buy Now', 'directorist-digital-marketplace' );
        ?>
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_attr_e( 'Title:', 'directorist-digital-marketplace' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>">
        </p>
        <?php
    }

    /**
     * Sanitize widget form values as they are saved.
     *
     * @see WP_Widget::update()
     *
     * @param array $new_instance Values just sent to be saved.
     * @param array $old_instance Previously saved values from database.
     *
     * @return array Updated safe values to be saved.
     */
    public function update( $new_instance, $old_instance ) {
        $instance = array();
        $instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';

        return $instance;
    }
}