<?php

namespace DirectoristDigitalMarketplace\Module\Core\Single;

use DirectoristDigitalMarketplace\Global_Helpers as Global_Helpers;
use DirectoristDigitalMarketplace\Helper\Listing as Sigle_Listing;


class Listing {

	/**
	 * Constuctor
	 * 
	 */
	function __construct() {
		add_filter( 'directorist_single_item_template', [ $this, 'overwrite_file_upload_template' ], 10, 2 );
		add_filter( 'directorist_single_section_template', array( $this, 'directorist_single_section_template' ), 10, 2 );

	}
	/**
	 * Print new section setplate for single listing
	 * @param string $template path
	 * @param array $args template data
	 * @return string $template single listing section template path
	 */
	public function directorist_single_section_template( $template, $field_data ) {
         
	
		$has_download = get_post_meta( get_the_ID(), '_digital_download', true );
		if( ! $has_download ) {
			return $template;
		}
		$data = [
            'price'     => Sigle_Listing::get_price( get_the_ID() ),
            'section'   => true,
            'tiers' 	=> get_post_meta( get_the_ID(), '_price_tiers', true ),
            'extras' 	=> get_post_meta( get_the_ID(), '_price_extras', true ),
            'hourly' 	=> get_post_meta( get_the_ID(), '_ddm_hourly', true ),
            'monthly' 	=> get_post_meta( get_the_ID(), '_ddm_monthly', true ),
            'quantity' 	=> get_post_meta( get_the_ID(), '_ddm_set_quantity', true ),
            'allow_quantity' => get_post_meta( get_the_ID(), '_ddm_allow_quantity', true ),

        ];
        $field_data['fields_data'] = $data;

		if( 'sell_digital_download' === $field_data['widget_name'] ) {
			$template .= Global_Helpers\get_template( 'single-listing/form', $field_data );
		}

		return $template;
	}

 	/**
	 * Register new section setplate for single listing
	 * @param string $template path
	 * @param array $args template data
	 * @return string $template single listing template path
	 */
	public function overwrite_file_upload_template( $template, $args ) {

		if( 'single/custom-fields/file' === $template ) {

			if( is_user_logged_in() && get_post_field( 'post_author', $args['listing_id'] ) == get_current_user_id() ) {
				return $template;
			}

			$digital_download = ! empty( $args['form_data']['digital_download'] ) ? $args['form_data']['digital_download'] : false;

			if( $digital_download ) {
				return;
			}
		}

		return $template;
	}

}