<?php

namespace DirectoristDigitalMarketplace\Module\Core;

use DirectoristDigitalMarketplace\Helper;

class Init {

    /**
	 * Constuctor
	 * 
     * @return void
	 */
	public function __construct() {

		// Register Controllers
        $controllers = $this->get_controllers();
        Helper\Serve::register_services( $controllers );

	}

    /**
	 * Controllers
	 * 
     * @return array
	 */
	protected function get_controllers() {
        return [
            Asset\Init::class,
            Form\Init::class,
            Single\Init::class,
            Admin\Init::class,
            Ajax\Init::class,
            Rest_API\Init::class,
            Shortcode\Init::class,
            Widget\Init::class,
        ];
    }

}