<?php

namespace DirectoristDigitalMarketplace\Module\Core\Form;

use DirectoristDigitalMarketplace\Global_Helpers as Global_Helpers;
use DirectoristDigitalMarketplace\Module\WooCommerce\Product;

class Listing {

	/**
	 * Constuctor
	 * 
	 */
	function __construct() {
        
		add_action( 'directorist_after_file_upload_form_field', [ $this, 'modify_file_upload_form_template' ] );
		add_filter( 'atbdp_ultimate_listing_meta_user_submission', [ $this, 'save_data' ], 10, 2 );
		add_action( 'edit_post', [ $this, 'save_admin_form_data' ], 10, 2 );
	}

	/**
	 * Save digital download meta data from admin add listing form
	 */

	public function save_admin_form_data( $post_id, $post ) {

		global $current_screen;

		if( ! $post ) {
			return;
		}

		if( ATBDP_POST_TYPE !== get_post_type( $post_id ) ) {
			return;
		}
		if( ! $current_screen ) {
			return;
		}

		if( empty( $_POST ) ) {
			return;
		}
		
		$fields = [ 'price_tiers', 'price_extras', 'ddm_hourly', 'ddm_monthly', 'ddm_allow_quantity', 'ddm_set_quantity', 'digital_download' ];
		$is_sellable = false;
		$metas = [];
		
        foreach( $fields as $field ) {
            $metas['_'. $field]  = !empty( $_POST[$field] ) ? directorist_clean( $_POST[$field] ) : '';
			
			if( 'digital_download' === $field  ) {
				$is_sellable = true;
			}
        }

		$post_metas = get_post_meta( $post_id );
		$downloadable_files = [];
		$keys = array_keys( $post_metas );
		foreach ($keys as $key) {
			if ( str_contains( $key, "_custom-file" ) ) {
				$file = ! empty( $post_metas[$key][0] ) ? $post_metas[$key][0] : '';
				array_push( $downloadable_files, $file );
			}
		}
		
		if( $downloadable_files ){
			$metas['_downloadable_files']  = $downloadable_files;
		}
		
		if( $is_sellable ) {
			$metas['_is_sellable'] = true;
		}
        foreach( $metas as $key => $value ) {
			update_post_meta( $post_id, $key, $value );
		}
	}


     /**
	 * @param string $template
	 * @param object $args
	 *
	 * @return string $template template path to include file
	 */

    public function save_data( $metas, $data ) {

        $fields = [ 'price_tiers', 'price_extras', 'ddm_hourly', 'ddm_monthly', 'ddm_allow_quantity', 'ddm_set_quantity', 'digital_download' ];
		$is_sellable = false;

        foreach( $fields as $field ) {
			
			$metas['_'. $field]  = ! empty( $data[$field] ) ? directorist_clean( $data[$field] ) : '';

			if( 'digital_download' === $field  ) {
				$is_sellable = true;
			}
        }
		
		$downloadable_files = [];
		$keys = array_keys( $metas );
		foreach ($keys as $key) {
			if ( str_contains( $key, "custom-file" ) ) {
				$file = $metas[$key];
				array_push( $downloadable_files, $file );
			}
		}
		if( $downloadable_files ){
			$metas['_downloadable_files']  = $downloadable_files;
		}

		if( $is_sellable ) {
			$metas['_is_sellable'] = true;
		}

        return $metas;
    }

    /**
	 * @param string $template
	 * @param object $args
	 *
	 * @return string $template template path to include file
	 */

	public function modify_file_upload_form_template( $args ) {
		?>
		<div class="ddm-listing-wrapper">
		<?php	
			$listing_id = ! empty( $args['form']->add_listing_id ) ? $args['form']->add_listing_id : false;
			$digital_download = ! empty( $args['digital_download'] ) ? $args['digital_download'] : false;

			if( ! $digital_download ) {
				return;
			}

			$has_download = get_post_meta( $listing_id, '_digital_download', true );
			?>
			<div class="ddm-checkbox directorist-switch">
				<input id="directorist_digital_download" class="directorist-switch-input" <?php checked( $has_download, 'on' );?> type="checkbox" name="digital_download">
				<label for="directorist_digital_download" class="directorist-switch-label"><?php esc_html_e( "Digital Download", "directorist-digital-download" ); ?></label>
			</div>
			<?php
			?>
			<div class="ddm-listing-wrapper-toggle digital-download-toggle">
			<?php

				$fields_data = [
					'tiers' 	=> get_post_meta( $listing_id, '_price_tiers', true ),
					'extras' 	=> get_post_meta( $listing_id, '_price_extras', true ),
					'hourly' 	=> get_post_meta( $listing_id, '_ddm_hourly', true ),
					'monthly' 	=> get_post_meta( $listing_id, '_ddm_monthly', true ),
					'quantity' 	=> get_post_meta( $listing_id, '_ddm_set_quantity', true ),
					'allow_quantity' => get_post_meta( $listing_id, '_ddm_allow_quantity', true ),

				];
				$args['fields_data'] = $fields_data;
				Global_Helpers\get_template( 'listing-form/file', $args );
			?>
			</div>
		</div>
		<?php
	}


}