<?php

namespace DirectoristDigitalMarketplace\Module\Core\Asset;

class PublicAsset extends AssetEnqueuer {
	
	/**
	 * Constuctor
	 * 
	 */
	function __construct() {
		$this->asset_group = 'public';
		add_action( 'wp_enqueue_scripts', [ $this, 'enqueue_scripts' ] );
		add_action( 'admin_enqueue_scripts', [ $this, 'enqueue_scripts' ] );
	}

    /**
	 * Load Admin CSS Scripts
	 *
	 * @return void
	 */
	public function load_scripts() {
        $this->add_css_scripts();
        $this->add_js_scripts();
    }

	/**
	 * Load Admin CSS Scripts
	 *
	 * @return void
	 */
	public function add_css_scripts() {
		$scripts = [];

		// $scripts['directorist-digital-marketplace-public-main-style'] = [
		// 	'file_name' => 'public-main',
		// 	'base_path' => DDM_CSS_PATH,
		// 	'deps'      => [],
		// 	'ver'       => $this->script_version,
		// 	'group'     => 'public',
		// ];

		$scripts['directorist-digital-marketplace-public-main-style'] = [
			'file_name' => 'public-main',
			'base_path' => DDM_CSS_PATH,
			'deps'      => [],
			'ver'       => $this->script_version,
			'group'     => 'public',
		];

		$scripts = array_merge( $this->css_scripts, $scripts);
		$this->css_scripts = $scripts;
	}

	/**
	 * Load Admin JS Scripts
	 *
	 * @return void
	 */
	public function add_js_scripts() {
		$scripts = [];

		// $scripts['directorist-digital-marketplace-public-script'] = [
		// 	'file_name'     => 'public-main',
		// 	'base_path'     => DDM_JS_PATH,
		// 	'deps'          => '',
		// 	'ver'           => $this->script_version,
		// 	'group'         => 'public',
		// ];

		$scripts['directorist-digital-marketplace-public-script'] = [
			'file_name'     => 'public-main',
			'base_path'     => DDM_JS_PATH,
			'deps'          => '',

			'ver'           => $this->script_version,
			'group'         => 'public',
			'data'         	=> [
				'ddm_script_helper' => [
					'i18n' => [
						'description' 	=> __( 'Description', 'directorist-digital-marketplace' ),
						'title' 		=> __( 'Title', 'directorist-digital-marketplace' ),
						'price' 		=> __( 'Price', 'directorist-digital-marketplace' ),
						'file' 			=> __( 'File URL', 'directorist-digital-marketplace' ),
					],
					'ajax_rul' => admin_url( 'admin-ajax.php' ),
					'is_admin' => is_admin(),
					'directorist_nonce' => wp_create_nonce( directorist_get_nonce_key() ),
					'trash_icon' => directorist_icon( 'las la-trash', false ),
					'drag_icon' => directorist_icon( 'las la-arrows-alt', false ),
				]
			],
		];

		$scripts = array_merge( $this->js_scripts, $scripts);
		$this->js_scripts = $scripts;
	}
}