<?php

namespace DirectoristDigitalMarketplace\Module\Core\Ajax;

use DirectoristDigitalMarketplace\Helper\Listing as Listing;
use DirectoristDigitalMarketplace\Module\WooCommerce\WC_Helper;
use function DirectoristDigitalMarketplace\Global_Helpers\ddm_get_first_array_value;

class Purchase {

	/**
	 * Constuctor
	 * 
	 */
	function __construct() {
		add_action( 'wp_ajax_directoirst_digital_product_purchase_request', [ $this, 'purchase_request' ] );
		add_action( 'wp_ajax_nopriv_directoirst_digital_product_purchase_request', [ $this, 'purchase_request' ] );

        add_action( 'woocommerce_before_calculate_totals', [ $this, 'update_cart_totals' ] );
		add_action( 'woocommerce_cart_calculate_fees', [ $this, 'update_cart_fees' ] );
	}

    		/**
	 * Updates cart totals.
	 *
	 * @param WC_Cart $cart Cart object.
	 */
	public function update_cart_totals( $cart ) {

		if( isset( $_GET['ddm_tier'] ) && ! empty( $_GET['ddm_tier'] ) ) { 

			// Remove action.
			remove_action( 'woocommerce_before_calculate_totals', [ $this, 'update_cart_totals' ] );

			$cart_item = ddm_get_first_array_value( $cart->get_cart() );

			$cart_item['data']->set_price( $cart_item['price'] );

		}

		return $cart;
	}

	/**
	 * Updates cart fees.
	 *
	 * @param WC_Cart $cart Cart object.
	 */
	public function update_cart_fees( $cart ) {
		foreach ( $cart->get_cart() as $cart_item ) {
			if ( isset( $cart_item['fees'] ) ) {
				foreach ( $cart_item['fees'] as $fee ) {
					if ( ddm_get_first_array_value( $fee, 'type' ) === 'percentage' ) {
						// Get amount.
						$amount = floatval( $cart->get_subtotal() );

						if ( isset( $cart_item['price_change'] ) && isset( $cart_item['quantity'] ) && ! get_option( 'listing_discount_extras', true ) ) {
							$amount -= $cart_item['price_change'] * $cart_item['quantity'];
						}

						$amount *= $fee['amount'] / 100;

						// Add fee.
						$cart->add_fee( $fee['name'], $amount );
					} else {
						$cart->add_fee( $fee['name'], $fee['amount'] );
					}
				}
			}
		}
	}


     /**
	 * @param string $template
	 * @param object $args
	 *
	 * @return string $template template path to include file
	 */

    public function purchase_request() {

        $data = [];

        // wp_send_json( $_POST );

        if ( ! directorist_verify_nonce() ) {
            $data['error'] = __( 'Something is wrong! Please refresh and retry.', 'directorist-digital-marketplace' );
            return wp_send_json( $data );
        }

        $listing_id = ! empty( $_POST['listing_id'] ) ? directorist_clean( wp_unslash( $_POST['listing_id'] ) ) : '';
        $quantity   = ! empty( $_POST['quantity'] ) ? directorist_clean( wp_unslash( $_POST['quantity'] ) ) : '';
        $extras     = ! empty( $_POST['extras'] ) ? directorist_clean( wp_unslash( $_POST['extras'] ) ) : '';
        $tiers      = ! empty( $_POST['tiers'] ) ? directorist_clean( wp_unslash( $_POST['tiers'] ) ) : '';

        $args = [
            'quantity'  => $quantity,
            'extras'    => $extras,
            'tiers'     => $tiers,
        ];
        $meta = [
            'quantity'     => 0,
            'fees'         => [],
            'price_tier'   => $tiers,
            'price_extras' => $extras,
            'price_change' => 0,
        ];

        $is_salable = Listing::is_sellable( $listing_id );

		if( ! $listing_id || ! $is_salable || ( 'publish' !== get_post_status( $listing_id ) ) ) {
            $data['error'] = __( 'Something went worng with the listing! Please contact listing owner.', 'directorist-digital-marketplace' );
            return wp_send_json( $data );
		}

        $add_to_checkout = WC_Helper::add_to_cart( $listing_id, $args, $meta );
		if( $add_to_checkout ) {
            $data['success'] = true;
            $data['redirect_url'] = add_query_arg( 'ddm_tier', $tiers, wc_get_checkout_url() );
        }else{
			$data['error'] = __( 'Something went worng with the listing! Please contact listing owner.', 'directorist-digital-marketplace' );
		}

        wp_send_json( $data );
    }

}