<?php

namespace DirectoristDigitalMarketplace\Module\Core\Ajax;

use DirectoristDigitalMarketplace\Helper\Listing as Listing;
use DirectoristDigitalMarketplace\Module\WooCommerce\WC_Helper;
use DirectoristDigitalMarketplace\Global_Helpers as Helper;

class Payout {

	/**
	 * Constuctor
	 * 
	 */
	function __construct() {
		add_action( 'wp_ajax_directoirst_digital_product_request_payout', [ $this, 'payout_request' ] );
		add_action( 'wp_ajax_nopriv_directoirst_digital_product_request_payout', [ $this, 'payout_request' ] );

	}


	public function payout_request() {
       
		$response	= [];
		$user		= wp_get_current_user();
        $user_id    = $user->ID;
        $details	= isset( $_POST['payment_method_details'] ) ? directorist_clean( wp_unslash( $_POST['payment_method_details'] ) ) : '';
        $method		= isset( $_POST['method'] ) ? directorist_clean( wp_unslash( $_POST['method'] ) ) : '';

		$payout_methods = (array) get_user_meta( $user_id, '_payout_methods', true );
		
		foreach( $payout_methods as $key => $value ) {
			$payout_methods[ $key ] = ! empty( $details[$key] ) ? $details[$key] : '';
		}
	
		update_user_meta( $user_id, '_payout_methods', $payout_methods );

		$minimum_payout 	= get_directorist_option( 'payout_minimum', 5 );
		$available_payout 	= get_user_meta( $user_id, '_ddm_available_payout', true );
		
		if( empty( $available_payout ) || ( (int)$available_payout < (int)$minimum_payout ) ){
			$response['error'] = true;
			$response['message'] = esc_html__( 'You have to earn the minimum payout ', 'directoirst-digital-marketplace' ) . $minimum_payout;
			wp_send_json( $response );
		}

		$user_payouts = Helper\get_payouts( $user_id );
		if( $user_payouts ) {
			$response['error'] = true;
			$response['message'] = esc_html__( 'You have a pending payout!', 'directoirst-digital-marketplace' );
			wp_send_json( $response );
		}

		$details = "
		$details[$method]
		
		=== Summery ===
		Payment Method: $method
		Amount: $available_payout
		";

		$args = [
			'post_title' => 'New payout request from ' . $user->display_name,
			'post_content' => $details,
			'meta_input' => [
				'_method' => $method,
				'_amount' => $available_payout,
			],
		];

		$payout = Helper\add_payout( $user_id, $args );

		if( is_wp_error( $payout ) ) {
			$response['error'] = true;
			$response['message'] = esc_html__( 'Error requesting payout, please try again.', 'directoirst-digital-marketplace' );
			wp_send_json( $response );
		}
		$response['message'] = esc_html__( 'Successfully submited your payout request', 'directoirst-digital-marketplace' );

		wp_send_json( $response );

    }

}