<?php

namespace DirectoristDigitalMarketplace\Module\Core\Admin;

class Settings {

	/**
	 * Constuctor
	 * 
	 */
	function __construct() {
		add_filter( 'atbdp_listing_type_settings_field_list', array( $this, 'atbdp_listing_type_settings_field_list' ) );
		add_filter( 'atbdp_email_templates_settings_sections', array( $this, 'atbdp_email_templates_settings_sections' ) );
		add_filter( 'atbdp_extension_fields', array( $this, 'atbdp_extension_fields' ) );
		add_filter( 'atbdp_extension_settings_submenu', array( $this, 'atbdp_extension_settings_submenus' ) );
	}

	public function atbdp_email_templates_settings_sections( $section ) {
		
		$section['new_download_confirmation'] = [
			'title'       => __('New Order Confirmation for Vendor', 'directorist-digital-download'),
			'description' => '',
			'fields'      => [
				'email_sub_approved_order', 'email_tmpl_approved_order'
			 ],
		];

		return $section;
	}

	public function atbdp_listing_type_settings_field_list( $marketplace_fields ) {
		$marketplace_fields['enable_marketplace'] = [
			'label'             => __('Digital Marketplace', 'directorist-digital-marketplace'),
			'type'              => 'toggle',
			'value'             => true,
			'description'       => __('You can disable it for users.', 'directorist-digital-marketplace'),
		];
		$marketplace_fields['vendor_commission_rate'] = [
			'type'              => 'number',
			'label'             => __('Commission rate', 'directorist-digital-marketplace'),
			'description'       => __('Rate in %', 'directorist-digital-marketplace'),
			'value'             => 10,
		];
		$marketplace_fields['payout_minimum'] = [
			'type'              => 'number',
			'label'             => __('Minimum payout amount', 'directorist-digital-marketplace'),
			'description'       => __('User can send payout request after earning the amount', 'directorist-digital-marketplace'),
			'value'             => 5,
		];

		$marketplace_fields['email_sub_approved_order']  = [
			'type'           => 'text',
			'label'          => __('Email Subject', 'directorist-digital-download'),
			'description'    => __('Edit the subject of new digital download sell for vendor.', 'directorist-digital-download'),
			'value'          => __('[==SITE_NAME==] : Order Confirmation for (#==LISTING_TITLE==)', 'directorist-digital-download'),
		];
		$marketplace_fields['email_tmpl_approved_order']  = [
			'type'           => 'textarea',
			'label'          => __('Email Body', 'directorist-digital-download'),
			'description'    => __('Edit the body of new digital download sell for vendor. HTML content is allowed too.', 'directorist-digital-download'),
			'value'          => __("
			Dear ==NAME==,
			Congratulations! You have a new order for '==LISTING_TITLE=='. You can now withdraw the amount from your Dashboard ==DASHBOARD_LINK==

			Thanks,
			The Administrator of ==SITE_NAME==
			", 'directorist-digital-download')
		];

		return $marketplace_fields;
	}

	public function atbdp_extension_fields(  $fields ) {
		$fields[] = ['enable_marketplace'];
		return $fields;
	}

	public function atbdp_extension_settings_submenus( $submenu ) {
		$submenu['marketplace_submenu'] = [
			'label' => __('Digital Marketplace', 'directorist-digital-marketplace'),
					'icon' => '<i class="las la-hand-holding-usd"></i>',
					'sections' => apply_filters( 'atbdp_marketplace_settings_controls', [
						'marketplace_section' => [
							'title'       => __('Digital Marketplace Settings', 'directorist-digital-marketplace'),
							'description' => __('You can Customize all the settings of Digital Marketplace Extension here', 'directorist-digital-marketplace'),
							'fields'      =>  [ 'vendor_commission_rate', 'payout_minimum' ],
						],
					] ),
		];

		return $submenu;
	}
}