<?php

namespace DirectoristDigitalMarketplace\Module\Core\Admin;

class Notice {

	/**
	 * Constuctor
	 * 
	 */
	function __construct() {
		add_action('init', array($this, 'notices'), 9);

	}

	public function notices() {

		if (!class_exists('WooCommerce')) {
            add_action('admin_notices', array($this, 'need_woocommerce'));
            return;
        }
        if (!class_exists('Directorist_Base')) {
            add_action('admin_notices', array($this, 'need_directorist'));
            return;
        }
	}

	  /**
     * WooCommerce not active notice.
     *
     * @return string Fallack notice.
     */

    public function need_directorist()
    {
        $error = sprintf(__('Directorist - Digital Marketplace requires %sDirectorist%s to be installed & activated!', 'directorist-digital-markletplace'), '<a target="_blank" href="http://wordpress.org/extend/plugins/directorist/">', '</a>');

        $message = '<div class="error notice is-dismissible"><p>' . $error . '</p></div>';
        //deactivate_plugins(plugin_basename( __FILE__ ));

        echo $message;
    }


    /**
     * WooCommerce not active notice.
     *
     * @return string Fallack notice.
     */

    public function need_woocommerce()
    {
        $error = sprintf(__('Directorist - Digital Marketplace requires %sWooCommerce%s to be installed & activated!', 'directorist-digital-markletplace'), '<a target="_blank" href="http://wordpress.org/extend/plugins/woocommerce/">', '</a>');

        $message = '<div class="error notice is-dismissible"><p>' . $error . '</p></div>';
        deactivate_plugins( DDM_FILE );

        echo $message;
    }
}