<?php

namespace DirectoristDigitalMarketplace\Module\Core\Admin;

class Builder {

	/**
	 * Constuctor
	 * 
	 */
	function __construct() {
		add_filter( 'atbdp_form_custom_widgets', [ $this, 'add_option_to_file_upload' ] );
		add_filter( 'atbdp_single_listing_other_fields_widget', [ $this, 'add_single_section_for_selling_file' ] );
	}



	/**
	 * Register new option to file upload custom field
	 *
	 * @return array $fields All the custom fields in submission form
	 */
	public function add_single_section_for_selling_file( $fields ) {

		$fields['sell_digital_download'] = [
			'type' => 'section',
			'label' => __( 'Digital Marketplace - Buy Now', 'directorist' ),
			'icon' => 'las la-cart',
			'options' => [
				'label' => [
					'type'  => 'text',
					'label' => __( 'Label', 'directorist' ),
					'value' => 'Digital Marketplace - Buy Now',
				],
				'custom_block_id' => [
					'type'  => 'text',
					'label'  => __( 'Custom block ID', 'directorist' ),
					'value' => '',
				],
				'custom_block_classes' => [
					'type'  => 'text',
					'label'  => __( 'Custom block Classes', 'directorist' ),
					'value' => '',
				],
			],
		];
		return $fields;
	}
	
	/**
	 * Register new option to file upload custom field
	 *
	 * @return array $fields All the custom fields in submission form
	 */
	public function add_option_to_file_upload( $fields ) {

		$new_option['digital_download'] = [
			'type'  => 'toggle',
			'label' => __( 'Digital Download', 'directorist' ),
			'value' => false,
		];

		$new_option['digital_tiers'] = [
			'type'  => 'toggle',
			'label' => __( 'Tiers', 'directorist' ),
			// 'description' => __( 'User can offer multiple price', 'directorist' ),
			'value' => true,
			'show_if' => [
				'where' => "self.digital_download",
				'conditions' => [
					['key' => 'value', 'compare' => '=', 'value' => true],
				],
			],
		];

		$new_option['digital_extras'] = [
			'type'  => 'toggle',
			'label' => __( 'Extra', 'directorist' ),
			// 'description' => __( 'User can offer extra featurs of the downloads', 'directorist' ),
			'value' => true,
			'show_if' => [
				'where' => "self.digital_download",
				'conditions' => [
					['key' => 'value', 'compare' => '=', 'value' => true],
				],
			],
		];

		$new_option['digital_hourly'] = [
			'type'  => 'toggle',
			'label' => __( 'Hourly', 'directorist' ),
			'value' => false,
			'show_if' => [
				'where' => "self.digital_download",
				'conditions' => [
					['key' => 'value', 'compare' => '=', 'value' => true],
				],
			],
		];

		// $new_option['digital_monthly'] = [
		// 	'type'  => 'toggle',
		// 	'label' => __( 'Monthly', 'directorist' ),
		// 	'value' => false,
		// 	'show_if' => [
		// 		'where' => "self.digital_download",
		// 		'conditions' => [
		// 			['key' => 'value', 'compare' => '=', 'value' => true],
		// 		],
		// 	],
		// ];

		$new_option['digital_quantity'] = [
			'type'  => 'toggle',
			'label' => __( 'Quantity', 'directorist' ),
			'value' => false,
			'show_if' => [
				'where' => "self.digital_download",
				'conditions' => [
					['key' => 'value', 'compare' => '=', 'value' => true],
				],
			],
		];

		$fields['file']['options'] += $new_option;
		return $fields;
	}
}