<?php

namespace DirectoristDigitalMarketplace\Helper;

use function DirectoristDigitalMarketplace\Global_Helpers\ddm_get_first_array_value;

class Listing {

    /**
     * return the Listing Object
     * 
     * @param int $listing_id Listing id
     * @return object
     */
    public static function get_listing( $listing_id ) {

        if( ! $listing_id ) {
            return;
        }

       return get_post( $listing_id );
        
    }

       /**
     * return listing tiers
     * 
     * @param int $listing_id Listing id
     * @return array
     */
    public static function status( $listing_id ) {

      return get_post_meta( $listing_id, '_price_tiers', true );
       
   }

    /**
     * return true if listing has digital download
     * 
     * @param int $listing_id Listing id
     * @return bool
     */
    public static function is_sellable( $listing_id ) {

      return get_post_meta( $listing_id, '_is_sellable', true );
        
    }

    /**
     * return listing tiers
     * 
     * @param int $listing_id Listing id
     * @return array
     */
    public static function get_price_tiers( $listing_id ) {

       return get_post_meta( $listing_id, '_price_tiers', true );
        
    }

    /**
     * return listing tiers
     * 
     * @param int $listing_id Listing id
     * @return array
     */
    public static function has_pricing( $listing_id ) {

       return self::get_price_tiers( $listing_id ) || self::get_price( $listing_id ) ;
        
    }

    /**
     * return listing extras
     * 
     * @param int $listing_id Listing id
     * @return array
     */
    public static function get_price_extras( $listing_id ) {

       return get_post_meta( $listing_id, '_price_extras', true );
        
    }

    /**
     * return listing price
     * 
     * @param int $listing_id Listing id
     * @return string
     */
    public static function get_price( $listing_id ) {

      $price      = get_post_meta( $listing_id, '_price', true );
      $tier       = ddm_get_first_array_value( self::get_price_tiers( $listing_id ) );
      $tier_price = ! empty( $tier['price'] ) ? $tier['price'] : '';
      return $price ? $price : $tier_price ;
        
    }

    /**
     * return listing get_quantity to sell
     * 
     * @param int $listing_id Listing id
     * @return string
     */
    public static function get_quantity( $listing_id ) {

       return get_post_meta( $listing_id, '_ddm_set_quantity', true );
        
    }

    /**
     * return listing purchase_note to sell
     * 
     * @param int $listing_id Listing id
     * @return string
     */
    public static function purchase_note( $listing_id ) {

       return get_post_meta( $listing_id, '_purchase_note', true );
        
    }

    /**
     * return listing get_quantity to sell
     * 
     * @param int $listing_id Listing id
     * @return string
     */
    public static function downloadable_attatchments( $listing_id ) {

       return get_post_meta( $listing_id, '_downloadable_files', true );
        
    }

    /**
     * return listing user__id 
     * 
     * @param int $listing_id Listing id
     * @return int
     */
    public static function user__id( $listing_id ) {

      if( ! $listing_id ) {
         return;
     }
     return get_post_field ( 'post_author', $listing_id );
   }


}