<?php
/**
 * Utility functions.
 */
namespace Directorist\Integrations\GamiPress;

if ( ! defined( 'ABSPATH' ) ) {
	die();
}

class Utils {

	public static function is_listing( $listing_id = 0 ) {
		$listing = get_post( $listing_id );
		return ( $listing && $listing->post_type === ATBDP_POST_TYPE );
	}

	public static function get_total_points( $args = array() ) {
		$args = wp_parse_args( $args, array(
			'points_type'  => 'all',
			'user_id'      => '0',
			'current_user' => 'no'
		) );
	
		// Check desired points types
		if ( $args['points_type'] === 'all' ) {
			$points_types = gamipress_get_points_types_slugs();
		} else {
			$points_types = explode( ',', $args['points_type'] );
		}
	
		// Force to set current user as user ID
		if( $args['current_user'] === 'yes' ) {
			$args['user_id'] = get_current_user_id();
		} else if( absint( $args['user_id'] ) === 0 ) {
			$args['user_id'] = get_current_user_id();
		}
	
		$total_points = 0;
		foreach ( $points_types as $points_type ) {
			// Ensure that this points type slug is registered
			if ( $args['points_type'] !== 'all' && ! in_array( $points_type, gamipress_get_points_types_slugs() ) ) {
				continue;
			}
	
			$total_points += gamipress_get_user_points( $args['user_id'], $points_type );
		}
	
		// Return the sum of points of all or specific points types
		return $total_points;
	}    

	public static function is_coupon_extension_enabled() {
		return class_exists( 'SWBDPCoupon' );
	}

	public static function is_discount_coupon_enabled() {
		return (bool) get_directorist_option( 'gamipress_enable_discount_coupon', false );
	}
}
