<?php
/**
 * Register triggers.
 */
namespace Directorist\Integrations\GamiPress;

if ( ! defined( 'ABSPATH' ) ) {
	die();
}

/**
 * Triggers class.
 */
class Triggers {

	public static function init() {
		add_filter( 'gamipress_activity_triggers', array( __CLASS__, 'register_activity_triggers' ) );
		add_filter( 'gamipress_log_extra_data_fields', array( __CLASS__, 'log_extra_data_fields' ), 10, 3 );
		add_filter( 'gamipress_log_event_trigger_meta_data', array( __CLASS__, 'log_event_trigger_meta_data' ), 10, 5 );
	}

	/**
	 * Register custom triggers.
	 *
	 * @param  array $triggers
	 *
	 * @return array
	 */
	public static function register_activity_triggers( $triggers ) {
		$triggers['Directorist'] = array(
			'directorist_publish_listing'        => __( 'Publish a new listing', 'directorist-gamipress-integration' ),
			'directorist_delete_listing'         => __( 'Delete a listing', 'directorist-gamipress-integration' ),
			'directorist_listing_expired'        => __( 'Listing expires', 'directorist-gamipress-integration' ),
			'directorist_new_report'             => __( 'User reports a listing', 'directorist-gamipress-integration' ),
			'directorist_get_report'             => __( 'Owner gets report on a listing', 'directorist-gamipress-integration' ),
			'directorist_new_review'             => __( 'User reviews a listing', 'directorist-gamipress-integration' ),
			'directorist_get_review'             => __( 'Owner gets review on a listing', 'directorist-gamipress-integration' ),
			'directorist_make_favorite'          => __( 'User favorites a listing', 'directorist-gamipress-integration' ),
			'directorist_get_favorite'           => __( 'Owners listing get favorites', 'directorist-gamipress-integration' ),
			'directorist_listing_become_popular' => __( 'Listing becomes popular', 'directorist-gamipress-integration' ),
			'directorist_purchase_plan'          => __( 'Purchase a plan', 'directorist-gamipress-integration' ),
		);

		return $triggers;
	}

	public static function log_event_trigger_meta_data( $log_meta, $user_id, $trigger, $site_id, $args ) {
		switch ( $trigger ) {
			case 'directorist_get_review':
			case 'directorist_new_review':
				$log_meta['post_id']    = $args['post_id'];
				$log_meta['comment_id'] = $args['comment_id'];
				$log_meta['rating']     = $args['rating'];
				break;

			case 'directorist_purchase_plan':
				$log_meta['post_id']  = $args['plan_id'];
				$log_meta['plan_id']  = $args['plan_id'];
				$log_meta['order_id'] = $args['order_id'];
				break;

			case 'directorist_listing_become_popular':
			case 'directorist_publish_listing':
			case 'directorist_listing_expired':
			case 'directorist_delete_listing':
			case 'directorist_new_report':
			case 'directorist_get_report':
			case 'directorist_make_favorite':
			case 'directorist_get_favorite':
				$log_meta['post_id'] = $args['post_id'];
				break;
		}
		
		return $log_meta;
	}

	/**
	 * Extra data fields
	 *
	 * @since 1.0.0
	 *
	 * @param array     $fields
	 * @param int       $log_id
	 * @param string    $type
	 *
	 * @return array
	 */
	public static function log_extra_data_fields( $fields, $log_id, $type ) {
		$prefix = '_gamipress_';

		$log = ct_get_object( $log_id );
		$trigger = $log->trigger_type;

		if ( $type !== 'event_trigger' ) {
			return $fields;
		}

		switch ( $trigger ) {
			case 'directorist_new_review':
			case 'directorist_get_review':
				$fields[] = array(
					'name'  => __( 'Rating', 'directorist-gamipress-integration' ),
					'desc'  => __( 'The total rating user has given.', 'directorist-gamipress-integration' ),
					'id'    => $prefix . 'rating',
					'type'  => 'text_small',
				);
		}

		return $fields;
	}
}

Triggers::init();
