<?php
/**
 * Register settings panel.
 */
namespace Directorist\Integrations\GamiPress;

if ( ! defined( 'ABSPATH' ) ) {
	die();
}

class Settings {

	public static function init() {
		add_action( 'atbdp_listing_type_settings_layout', array( __CLASS__, 'register_panel' ) );
		add_filter( 'atbdp_listing_type_settings_field_list', array( __CLASS__, 'register_fields' ) );
	}

	protected static function get_coupon_fields() {
		$display_condition = [
			'where'      => 'gamipress_enable_discount_coupon',
			'conditions' => [
				[
					'key'     => 'value',
					'compare' => '=',
					'value'   => true
				],
			],
		];
		
		$fields = array(
			'gamipress_enable_discount_coupon' => array(
				'type'        => 'toggle',
				'label'       => __( 'Enabled Discount Coupon', 'directorist-gamipress-integration' ),
				'description' => __( 'Allow users to generate coupon and purchase listings package using points.', 'directorist-gamipress-integration' ),
				'value'       => false,
			),
		);

		if ( ! Utils::is_coupon_extension_enabled() ) {
			$fields['gamipress_coupon_missing_notice'] = array(
				'type'        => 'note',
				'title'       => __( 'Coupon Extension Required!', 'directorist-gamipress-integration' ),
				'description' => __( 'Directorist Coupon extension is required to enable this feature. Please install and activate the extension.', 'directorist-gamipress-integration' ),
				'show-if'     => $display_condition,
			);
		} else {
			$fields['gamipress_discount_type'] = array(
				'type'        => 'select',
				'label'       => __( 'Discount Type', 'directorist-gamipress-integration' ),
				'value'       => 'fixed-discount',
				'options'     => array(
					array(
						'value' => 'fixed-discount',
						'label' => __( 'Fixed Discount', 'directorist-gamipress-integration' ),
					),
					array(
						'value' => 'percent-discount',
						'label' => __( 'Percent Discount', 'directorist-gamipress-integration' ),
					),
				),
				'show-if'     => $display_condition,
			);

			$fields['gamipress_discount_amount'] = array(
				'type'        => 'number',
				'label'       => __( 'Amount', 'directorist-gamipress-integration' ),
				'description' => __( 'Set the percent or fixed amount.', 'directorist-gamipress-integration' ),
				'value'       => 0,
				'min'         => 0,
				'show-if'     => $display_condition,
			);

			// $fields['gamipress_discount_max_usage'] = array(
			// 	'type'        => 'number',
			// 	'label'       => __( 'Max Usage', 'directorist-gamipress-integration' ),
			// 	'description' => __( 'Set maximum how many times a discount can be claimed.', 'directorist-gamipress-integration' ),
			// 	'value'       => 1,
			// 	'min'         => 1,
			// 	'show-if'     => $display_condition,
			// );

			$fields['gamipress_discount_points_required'] = array(
				'type'        => 'number',
				'label'       => __( 'Points Required', 'directorist-gamipress-integration' ),
				'description' => __( 'Set the amount of points required.', 'directorist-gamipress-integration' ),
				'value'       => 1000,
				'min'         => 0,
				'show-if'     => $display_condition,
			);
		}

		return $fields;
	}

	public static function register_fields( $fields ) {
		return array_merge(
			$fields,
			self::get_coupon_fields()
		);
	}

	public static function register_panel( $layout ) {
		$layout['extension_settings']['submenu']['gamipress-integration'] = array(
			'label' => __( 'GamiPress', 'directorist-gamipress-integration' ),
			'icon' => '<i class="fa fa-circle"></i>',
			'sections' => array(
				'gamipress_coupon_settings' => array(
					'title' => __( 'Discount Coupon', 'directorist-gamipress-integration' ),
					'fields' => array_keys( self::get_coupon_fields() )
				),
			),
		);

		return $layout;
	}
}

Settings::init();
