<?php
/**
 * Rules engine class.
 */
namespace Directorist\Integrations\GamiPress;

use Directorist\Review\Comment_Meta;

if ( ! defined( 'ABSPATH' ) ) {
	die();
}

class Rules_Engine {

	public static function init() {
		add_filter( 'user_deserves_achievement', array( __CLASS__, 'user_meets_points_requirement' ), 10, 6 );
	}

	public static function user_meets_points_requirement( $return = false, $user_id = 0, $achievement_id = 0, $trigger_type = '', $site_id = 0, $args = array() ) {
		// Check if user has access to the achievement ($return will be false if user has exceed the limit or achievement is not published yet)
		if ( ! $return ) {
			return $return;
		}

		if ( empty( $trigger_type ) ) {
			$trigger_type = gamipress_get_post_meta( $achievement_id, '_gamipress_trigger_type' );
		}

		if ( $trigger_type === 'directorist_new_review' || $trigger_type === 'directorist_get_review' ) {
			$points_condition = gamipress_get_post_meta( $achievement_id, '_gamipress_points_condition', true );
			$required_rating  = gamipress_get_post_meta( $achievement_id, '_gamipress_directorist_review_rating', true );
			$reviewer_rating  = $args['rating'];

			if ( empty( $points_condition ) ) {
			    $points_condition = 'greater_or_equal';
			}

			if ( gamipress_number_condition_matches( $reviewer_rating, $required_rating, $points_condition ) ) {
			    // If the user just earned the achievement, though, don't let them earn it again
			    // This prevents an infinite loop if the achievement has no maximum earnings limit
			    $minimum_time  = current_time( 'timestamp' ) - 1;
			    $last_activity = absint( gamipress_achievement_last_user_activity( $achievement_id, $user_id ) );
	
			    if ( $last_activity > $minimum_time ) {
					$return = false;
				}
			} else {
			    $return = false;
			}
		}

		return $return;
	}
}

Rules_Engine::init();
