<?php
/**
 * Register custom requirements ui.
 */
namespace Directorist\Integrations\GamiPress;

if ( ! defined( 'ABSPATH' ) ) {
	die();
}

class Requirements {

	public static function init() {
		add_action( 'gamipress_ajax_update_requirement', array( __CLASS__, 'ajax_update' ), 10, 2 );
		add_filter( 'gamipress_requirement_object', array( __CLASS__, 'requirement_object' ), 10, 2 );
		add_action( 'gamipress_requirement_ui_html_after_achievement_post', array( __CLASS__, 'register_ui_fields' ), 10, 2 );
	}

	/**
	 * Add custom fields to the requirement object
	 *
	 * @param $requirement
	 * @param $requirement_id
	 *
	 * @return array
	 */
	public static function requirement_object( $requirement, $requirement_id ) {
		if ( isset( $requirement['trigger_type'] ) && (
			$requirement['trigger_type'] === 'directorist_new_review' ||
			$requirement['trigger_type'] === 'directorist_get_review' ) ) {
				
			$requirement['directorist_review_rating'] = gamipress_get_post_meta( $requirement_id, '_gamipress_directorist_review_rating', true );
		}

		return $requirement;
	}

	/**
	 * Custom fields on requirements UI
	 *
	 * @param $requirement_id
	 * @param $post_id
	 */
	public static function register_ui_fields( $requirement_id, $post_id ) {
		// Review rating
		$rating = gamipress_get_post_meta( $requirement_id, '_gamipress_directorist_review_rating', true );
		$rating = ! empty( $rating ) ? round( (float) $rating, 2 ) : 0;

		$html_id = 'gamipress-directorist-review-rating-' . $requirement_id;
		?>
	
		<span class="gamipress-directorist-review-rating-wrap">
			<input class="gamipress-directorist-review-rating" id="<?php echo esc_attr( $html_id ); ?>" type="number" step="any" min="0" max="5" value="<?php echo esc_attr( $rating ); ?>">
			<label for="<?php echo esc_attr( $html_id ); ?>"><?php echo esc_html_x( 'rating(s)', 'input label', 'directorist-gamipress-integration' ); ?></label>
		</span>
		<?php
	}

	/**
	 * Custom handler to save custom fields on requirements UI
	 *
	 * @param $requirement_id
	 * @param $requirement
	 */
	public static function ajax_update( $requirement_id, $requirement ) {
		if ( isset( $requirement['trigger_type'] ) && (
			$requirement['trigger_type'] === 'directorist_new_review' ||
			$requirement['trigger_type'] === 'directorist_get_review' ) ) {

			$rating = ! empty( $requirement['directorist_review_rating'] ) ? round( (float) $requirement['directorist_review_rating'], 2 ) : 0;
			if ( $rating ) {
				// Save the rating field
				gamipress_update_post_meta( $requirement_id, '_gamipress_directorist_review_rating', $rating );
			} else {
				gamipress_delete_post_meta( $requirement_id, '_gamipress_directorist_review_rating' );
			}
		}
	}
}

Requirements::init();
