<?php
/**
 * Register dashboard tab and render tab content.
 */
namespace Directorist\Integrations\GamiPress;

if ( ! defined( 'ABSPATH' ) ) {
	die();
}

class Dashboard {

	public static function init() {
		add_filter( 'directorist_dashboard_tabs', array( __CLASS__, 'register_tab' ) );
	}

	public static function register_tab( $tabs ) {
		$tabs['dashboard_gamipress'] = array(
			'title'    => self::get_title(),
			'content'  => self::get_content(),
			'icon'	   => 'fas fa-star',
		);

		return $tabs;
	}

	public static function get_title() {
		return esc_html( 'Points', 'directorist-gamipress-integration' );
	}

	public static function get_content() {
		ob_start();

		?>
		<div class="directorist-tab-gamipress directorist-gamipress-wrap">
			<h2 class="directorist-tab-title"><?php esc_html_e( 'Achievements', 'directorist-gamipress-integration' ); ?></h2>
			<?php echo do_shortcode( '[gamipress_achievements current_user="yes" columns="3" filter="no" search="no"]' ); ?>

			<h2 class="directorist-tab-title"><?php esc_html_e( 'Ranks', 'directorist-gamipress-integration' ); ?></h2>
			<?php echo do_shortcode( '[gamipress_ranks current_user="yes" columns="3"]' ); ?>

			<h2 class="directorist-tab-title"><?php esc_html_e( 'Points', 'directorist-gamipress-integration' ); ?></h2>
			<?php echo do_shortcode( '[gamipress_user_points current_user="yes" columns="3"]' ); ?>

			
			<?php if ( Utils::is_coupon_extension_enabled() && Utils::is_discount_coupon_enabled() ) : ?>
				<h2 class="directorist-tab-title"><?php esc_html_e( 'Redeem Points', 'directorist-gamipress-integration' ); ?></h2>
				<div class="directorist-gamipress-redeem-points">
					<?php
					$total_points        = Utils::get_total_points( array( 'current_user' =>  'yes' ) );
					$required_points     = (int) get_directorist_option( 'gamipress_discount_points_required', 0 );
					$points_used         = (int) get_user_meta( get_current_user_id(), 'directorist_gamipress_used_points', true );
					$available_points    = ( $total_points - $points_used );
					$claimed_coupon_id   = get_user_meta( get_current_user_id(), 'directorist_gamipress_coupon_id', true );
					$claimed_coupon_code = get_post_meta( $claimed_coupon_id, 'swbdpc_coupon_code', true );

					if ( $claimed_coupon_id && $claimed_coupon_code ) {
						$message = __( 'You already claimed discount and have got a coupon. Use the coupon code and enjoy discount on checkout.', 'directorist-gamipress-integration' );
					} else if ( $available_points < $required_points ) {
						// translators: 1: Available points. 2: Used points. 3: Remaining points to claim.
						$message = sprintf(
							__( 'You have %1$s point(s) available and you already used %2$s point(s). You need %3$s more point(s) to claim discount.', 'directorist-gamipress-integration' ),
							$available_points,
							$points_used,
							( $required_points - $available_points )
						);
					} else {
						// translators: 1: Available points. 2: Used points.
						$message = sprintf(
							__( 'You have %1$s point(s) available and you already used %2$s point(s). Claim your discount by clicking on the button.', 'directorist-gamipress-integration' ),
							$available_points,
							$points_used
						);
					}
					?>
					<p class="directorist-alert directorist-alert-info"><?php echo esc_html( $message ); ?></p>

					<?php if ( $claimed_coupon_id && $claimed_coupon_code ) : ?>
						<p><?php printf( esc_html__( 'Coupon code: %s' ) , '<code>' . $claimed_coupon_code . '</code>' ); ?></p>
					<?php endif; ?>

					<?php if ( ! ( $claimed_coupon_id && $claimed_coupon_code ) && ( $available_points >= $required_points ) ) {
						$args= array(
							'nonce'  => wp_create_nonce( 'directorist_gamipress_claim_discount' ),
							'action' => 'directorist_gamipress_claim_discount'
						);
						$ajax_url = add_query_arg( $args, admin_url( 'admin-ajax.php' ) );
						printf(
							'<button type="button" class="directorist-btn directorist-btn-primary directorist-gamipress-claim-discount" data-url="%1$s">%2$s</button>',
							$ajax_url,
							esc_html__( 'Claim Discount', 'directorist-gamipress-integration' )
						);
					} ?>
				</div>
			<?php endif; ?>
		</div>
		<?php

		return ob_get_clean();
	}
}

Dashboard::init();
