<?php
/**
 * Display rank and point details on author details page.
 */
namespace Directorist\Integrations\GamiPress;

if ( ! defined( 'ABSPATH' ) ) {
	die();
}

class Author {

	public static function init() {
		add_action( 'directorist_author_listing_after_about_section', array( __CLASS__, 'render' ) );
	}

	public static function render() {
		$user_id = \Directorist\Directorist_Listing_Author::instance()->get_id();
		?>
		<div class="directorist-author-gamipress directorist-gamipress-wrap">
			<h2 class="directorist-segment-title"><?php esc_html_e( 'Achievements', 'directorist-gamipress-integration' ); ?></h2>
			<?php echo do_shortcode( '[gamipress_achievements current_user="no" user_id="' . $user_id . '" columns="3" filter="no" filter_value="completed" search="no"]' ); ?>

			<h2 class="directorist-segment-title"><?php esc_html_e( 'Ranks', 'directorist-gamipress-integration' ); ?></h2>
			<?php echo do_shortcode( '[gamipress_ranks current_user="no" user_id="' . $user_id . '" columns="3"]' ); ?>

			<h2 class="directorist-tab-title"><?php esc_html_e( 'Points', 'directorist-gamipress-integration' ); ?></h2>
			<?php echo do_shortcode( '[gamipress_user_points current_user="no" user_id="' . $user_id . '" columns="3"]' ); ?>
		</div>
		<?php
	}
}

Author::init();
