<?php
/**
 * Manage css and JS.
 */
namespace Directorist\Integrations\GamiPress;

if ( ! defined( 'ABSPATH' ) ) {
	die();
}

class Assets {

	public static function init() {
		add_action( 'wp_enqueue_scripts', array( __CLASS__, 'enqueue_frontend_scripts' ) );
		add_action( 'admin_enqueue_scripts', array( __CLASS__, 'enqueue_admin_scripts' ) );
	}

	public static function enqueue_frontend_scripts() {
		$author_page    = (int) get_directorist_option( 'author_profile_page', 0 );
		$dashboard_page = (int) get_directorist_option( 'user_dashboard', 0 );

		if ( ( $author_page && is_page( $author_page ) ) || ( $dashboard_page && is_page( $dashboard_page ) ) ) {
			wp_enqueue_style(
				directorist_gamipress()->slug,
				directorist_gamipress()->plugin_url . 'assets/css/style.css',
				array(),
				directorist_gamipress()->version
			);

			wp_enqueue_script(
				directorist_gamipress()->slug,
				directorist_gamipress()->plugin_url . 'assets/js/script.js',
				array( 'jquery' ),
				directorist_gamipress()->version,
				true
			);
		}
	}

	public static function enqueue_admin_scripts() {
		global $post_type;

		if ( $post_type === 'points-type'
			|| in_array( $post_type, gamipress_get_achievement_types_slugs(), true )
			|| in_array( $post_type, gamipress_get_rank_types_slugs(), true ) ) {

			wp_enqueue_script(
				directorist_gamipress()->slug,
				directorist_gamipress()->plugin_url . 'assets/js/admin-script.js',
				array( 'jquery' ),
				directorist_gamipress()->version,
				true
			);
		}
	}
}

Assets::init();
