<?php
/**
 * Plugin Name: Directorist - GamiPress Integration
 * Plugin URI:  https://directorist.com/product/directorist-gamipress-integration/
 * Description: You have already Gamified your site, now take it to the next level!
 * Version:     0.6.0
 * Author:      wpWax
 * Author URI:  https://wpwax.com
 * RequiresPHP: 7.0.0
 * RequiresWP:  5.0
 * Text Domain: directorist-gamipress-integration
 * Domain Path: /languages/
 *
 * @package         	Directorist_GamiPress_Integration
 * @author          	wpWax
 * @copyright       	Copyright (c) wpWax
*/
if ( ! defined( 'ABSPATH' ) ) {
	die();
}

class Directorist_GamiPress_Integration {

	/**
	 * Plugin slug.
	 *
	 * @var string
	 */
	public $slug = 'directorist-gamipress-integration';

	/**
	 * Plugin version.
	 *
	 * @var string
	 */
	public $version = '0.6.0';

	/**
	 * Plugin dir path.
	 *
	 * @var string
	 */
	public $plugin_dir;

	/**
	 * Plugin url.
	 *
	 * @var string
	 */
	public $plugin_url;

	/**
	 * Singalaton instance.
	 *
	 * @var object
	 */
	private static $instance = null;

	public static function instance() {
		if ( is_null( self::$instance ) ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	private function __construct() {
		$this->init();
	}

	public function init() {
		add_action( 'plugins_loaded', array( $this, 'on_plugins_loaded' ), 20 );
		add_action( 'plugins_loaded', array( $this, 'load_plugin_textdomain' ), 20 );
	}

	public function on_plugins_loaded() {
		// Show directorist missing notice
		if ( ! class_exists( 'Directorist_Base', false ) ) {
			if ( self::can_see_warning() ) {
				add_action( 'admin_notices', array( __CLASS__, 'show_directorist_missing_admin_notice' ) );
			}
			return;
		}

		// Show gamipress missing notice
		if ( ! class_exists( 'GamiPress', false ) ) {
			if ( self::can_see_warning() ) {
				add_action( 'admin_notices', array( __CLASS__, 'show_gamipress_missing_admin_notice' ) );
			}
			return;
		}

		$this->includes();
		$this->setup_props();
	}

	public function setup_props() {
		$this->plugin_dir = plugin_dir_path( __FILE__ );
		$this->plugin_url = plugin_dir_url( __FILE__ );
	}

	public function includes() {
		require_once $this->plugin_dir . 'includes/class-utils.php';
		require_once $this->plugin_dir . 'includes/class-triggers.php';
		require_once $this->plugin_dir . 'includes/class-listeners.php';
		require_once $this->plugin_dir . 'includes/class-author.php';
		require_once $this->plugin_dir . 'includes/class-assets.php';
		require_once $this->plugin_dir . 'includes/class-rules-engine.php';

		if ( is_user_logged_in() ) {
			require_once $this->plugin_dir . 'includes/class-dashboard.php';
			require_once $this->plugin_dir . 'includes/class-coupon-manager.php';
		}

		if ( is_admin() ) {
			require_once $this->plugin_dir . 'includes/class-settings.php';
			require_once $this->plugin_dir . 'includes/class-requirements.php';
		}
	}

	public function load_plugin_textdomain() {
		load_plugin_textdomain(
			$this->slug,
			false,
			dirname( plugin_basename( __FILE__ ) ) . '/languages'
		);
	}

	protected static function can_see_warning() {
		return ( current_user_can( 'install_plugins' ) || current_user_can( 'activate_plugins' ) );
	}

	/**
	 * Show directorist missing admin notice.
	 * 
	 * When installed but deactivated it'll show an activation link,
	 * and when not installed it'll show an installation link.
	 *
	 * @return void
	 */
	public static function show_directorist_missing_admin_notice() {
		$plugin_slug = 'directorist';
		$plugin_file = "{$plugin_slug}/directorist-base.php";

		if ( file_exists( trailingslashit( WP_PLUGIN_DIR ) . $plugin_file ) ) {
			$notice_title = __( 'Activate Directorist', 'directorist-gamipress-integration' );
			$notice_url   = wp_nonce_url(
				"plugins.php?action=activate&plugin={$plugin_file}&plugin_status=all&paged=1",
				"activate-plugin_{$plugin_file}"
			);
		} else {
			$notice_title = __( 'Install Directorist', 'directorist-gamipress-integration' );
			$notice_url = wp_nonce_url(
				self_admin_url( "update.php?action=install-plugin&plugin={$plugin_slug}" ),
				"install-plugin_{$plugin_slug}"
			);
		}

		$notice = wp_kses_data( sprintf(
			/* translators: 1: Plugin name 2: Directorist 3: Directorist installation link */
			__( '%1$s requires %2$s to be installed and activated to function properly. %3$s', 'directorist-gamipress-integration' ),
			'<strong>' . __( 'Directorist Gamipress Integration', 'directorist-gamipress-integration' ) . '</strong>',
			'<strong>' . __( 'Directorist', 'directorist-gamipress-integration' ) . '</strong>',
			'<a href="' . esc_url( $notice_url ) . '">' . $notice_title . '</a>'
		) );

		printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $notice );
	}

	/**
	 * Show gamipress missing admin notice.
	 * 
	 * When installed but deactivated it'll show an activation link,
	 * and when not installed it'll show an installation link.
	 *
	 * @return void
	 */
	public static function show_gamipress_missing_admin_notice() {
		$plugin_slug = 'gamipress';
		$plugin_file = "{$plugin_slug}/gamipress.php";

		if ( file_exists( trailingslashit( WP_PLUGIN_DIR ) . $plugin_file ) ) {
			$notice_title = __( 'Activate GamiPress', 'directorist-gamipress-integration' );
			$notice_url   = wp_nonce_url(
				"plugins.php?action=activate&plugin={$plugin_file}&plugin_status=all&paged=1",
				"activate-plugin_{$plugin_file}"
			);
		} else {
			$notice_title = __( 'Install GamiPress', 'directorist-gamipress-integration' );
			$notice_url = wp_nonce_url(
				self_admin_url( "update.php?action=install-plugin&plugin={$plugin_slug}" ),
				"install-plugin_{$plugin_slug}"
			);
		}

		$notice = wp_kses_data( sprintf(
			/* translators: 1: Plugin name 2: Directorist 3: Directorist installation link */
			__( '%1$s requires %2$s to be installed and activated to function properly. %3$s', 'directorist-gamipress-integration' ),
			'<strong>' . __( 'Directorist GamiPress Integration', 'directorist-gamipress-integration' ) . '</strong>',
			'<strong>' . __( 'GamiPress', 'directorist-gamipress-integration' ) . '</strong>',
			'<a href="' . esc_url( $notice_url ) . '">' . $notice_title . '</a>'
		) );

		printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $notice );
	}
}

function directorist_gamipress() {
	return Directorist_GamiPress_Integration::instance();
}

directorist_gamipress();
