<?php
/**
 * Plugin Name: Directorist - Mark as Sold
 * Plugin URI: http://directorist.com/
 * Description: This is an extension for Directorist Plugin. You can show visitors if a particular item is sold or not.
 * Version: 1.2.1
 * Author: wpWax
 * Author URI: http://directorist.com/
 * License: GPLv2 or later
 * Text Domain: directorist-mark-as-sold
 * Domain Path: /languages
 */
// prevent direct access to the file
defined('ABSPATH') || die('No direct script access allowed!');
if (!class_exists('Directorist_Mark_as_Sold')) {
    final class Directorist_Mark_as_Sold
    {
        /** Singleton *************************************************************/
        /**
         * @var Directorist_Mark_as_Sold The one true Directorist_Mark_as_Sold
         * @since 1.0
         */
        private static $instance;

        /**
         * Main Directorist_Mark_as_Sold Instance.
         *
         * Insures that only one instance of Directorist_Mark_as_Sold exists in memory at any one
         * time. Also prevents needing to define globals all over the place.
         *
         * @return object|Directorist_Mark_as_Sold The one true Directorist_Mark_as_Sold
         * @uses Directorist_Mark_as_Sold::setup_constants() Setup the constants needed.
         * @uses Directorist_Mark_as_Sold::includes() Include the required files.
         * @uses Directorist_Mark_as_Sold::load_textdomain() load the language files.
         * @see  Directorist_Mark_as_Sold()
         * @since 1.0
         * @static
         * @static_var array $instance
         */
        public static function instance()
        {
            if (!isset(self::$instance) && !(self::$instance instanceof Directorist_Mark_as_Sold)) {
                self::$instance = new Directorist_Mark_as_Sold;
                self::$instance->setup_constants();
                self::$instance->includes();
                add_action('plugins_loaded', array(self::$instance, 'load_textdomain'));
                add_action('wp_enqueue_scripts', array(self::$instance, 'load_needed_scripts'));
                add_action('admin_enqueue_scripts', array(self::$instance, 'load_admin_needed_scripts'));
                // Add setting section to the Directorist settings page.
                add_filter('atbdp_license_settings_controls', array(self::$instance, 'mas_license_settings_controls'));
                add_action('atbdp_listing_contact_owner_submitted', array(self::$instance, 'atbdp_listing_contact_owner_submitted'));
                add_filter('atbdp_listing_price', array(self::$instance, 'atbdp_listing_price'));
                add_action('atbdp_user_dashboard_before_button', array(self::$instance, 'atbdp_user_dashboard_before_button'));
                add_action('wp_ajax_mas_user_dashboard_action', array(self::$instance, 'mas_user_dashboard_action'));
                add_action('wp_ajax_noprive_mas_user_dashboard_action', array(self::$instance, 'mas_user_dashboard_action'));
                add_action('atbdp_before_listing_title', array(self::$instance, 'atbdp_grid_lower_badges'));

                // exclude from public view
                add_filter('atbdp_search_listings_meta_queries', array(self::$instance, 'pyn_custom_meta_queries'));
                add_filter('atbdp_all_listings_meta_queries', array(self::$instance, 'pyn_custom_meta_queries'));
                add_filter('atbdp_single_location_meta_queries', array(self::$instance, 'pyn_custom_meta_queries'));
                add_filter('atbdp_single_tag_meta_queries', array(self::$instance, 'pyn_custom_meta_queries'));
                add_filter('atbdp_single_category_meta_queries', array(self::$instance, 'pyn_custom_meta_queries'));
                add_filter('atbdp_author_listings_meta_queries', array(self::$instance, 'pyn_author_custom_meta_queries'));

                add_filter( 'atbdp_listing_type_settings_field_list', array(self::$instance, 'atbdp_listing_type_settings_field_list' ) );
                add_action( 'atbdp_all_listings_badge_template', array( self::$instance, 'atbdp_all_listings_badge_template' ) );
                add_filter( 'directorist_single_item_template', array( self::$instance, 'directorist_single_item_template' ), 10, 2 );


                // settings
                add_filter( 'atbdp_listing_type_settings_field_list', array( self::$instance, 'atbdp_listing_type_settings' ) );
                add_filter( 'atbdp_extension_fields', array( self::$instance, 'atbdp_extension_fields' ) );
                add_filter( 'atbdp_extension_settings_submenu', array( self::$instance, 'atbdp_extension_settings_submenus' ) );

                //dasbbord
                add_filter( 'directorist_dashboard_listing_action_items', array( self::$instance, 'atbdp_dashboard_listing_action_item' ) );

            }
            return self::$instance;
        }


        public function directorist_single_item_template( $template, $field_data ) {

            $is_negotiated = get_post_meta(get_the_ID(), '_negotiate', true);
            if( 'price' === $field_data['widget_name'] ) {
                if ( ( 'yes' === $is_negotiated ) || ( 'sold' === $is_negotiated ) ) {
                    $template = $this->badge_html();
                }
             }
             return $template;

        }

        public function atbdp_all_listings_badge_template( $field  ) {
            switch ($field['widget_key']) {
                case 'sold_badge':
                $this->badge_html();
                break;
            }
        }

        public function badge_html() {

            $sold_badge     = get_directorist_option('sold_badge', __('Sold', 'directorist-mark-as-sold'));
            $negotiation    = get_directorist_option('negotiation_badge', __('Negotiating', 'directorist-mark-as-sold'));
            $sold_class = directorist_legacy_mode() ? 'atbd_badge atbdp_info_list atbd_badge_sold' : 'directorist-badge directorist-info-item directorist-badge-sold';
            $negotiation_class = directorist_legacy_mode() ? 'atbd_badge atbdp_info_list atbd_badge_negotiation' : 'directorist-badge directorist-info-item directorist-badge-negotiation';
            $badge          = '';

            $is_negotiated  = get_post_meta( get_the_ID(), '_negotiate', true );
            if ('sold' == $is_negotiated) {
                $badge          = "<span class='$sold_class'>$sold_badge</span>";
            }
            elseif( 'yes' == $is_negotiated ){
                $badge          = "<span class='$negotiation_class'>$negotiation</span>";
            }

            echo $badge;
        }

        public function atbdp_dashboard_listing_action_item( $items ) {

            global $post;
            $is_negotiated      = get_post_meta( $post->ID, '_negotiate', true );
            $sold_checked       = ( 'sold' == $is_negotiated ) ? ' directorist-mas-checked' : '';
            $negotiate_checked  = ( 'yes' == $is_negotiated ) ? ' directorist-mas-checked' : '';
            $negotiate_label    = __('Mark as Negotiating', 'directorist-mark-as-sold');
            $sold_label         = __('Mark as Sold', 'directorist-mark-as-sold');
            $owner_can_mark     = get_directorist_option( 'owner_can_mark', true );

            if( ! $owner_can_mark ) return $items;

             $items['mark_negotiate'] = array(
                'class'			    => 'mark_negotiate directorist-checkbox-absent-input' . $negotiate_checked,
                'data_attr'			=>	'data-listing-id="'. $post->ID . '" data-action="negotiate" id="'. $post->ID . '"' ,
                'link'				=>	'#',
                'icon'				=>  directorist_icon( 'fas fa-check', false, 'directorist-check-icon' ),
                'label'				=>  '<span class="directorist-checkbox-absent-input__label">'.$negotiate_label.'</span>'
             );

             $items['mark_sold'] = array(
                'class'			    => 'mark_sold directorist-checkbox-absent-input' . $sold_checked,
                'data_attr'			=>	'data-listing-id="'. $post->ID . '" data-action="sold" id="'. $post->ID . '"',
                'link'				=>	'#',
                'icon'				=>  directorist_icon( 'fas fa-check', false, 'directorist-check-icon' ),
                'label'				=>  '<span class="directorist-checkbox-absent-input__label">'.$sold_label.'</span>'
             );

             return $items;
        }

        public function atbdp_extension_fields(  $fields ) {
            $fields[] = ['enable_mark_as_sold'];
            return $fields;
        }

        public function atbdp_listing_type_settings( $mark_sold_fields ) {

            $mark_sold_fields['enable_mark_as_sold'] = [
                'label'             => __('Mark as Sold', 'directorist-mark-as-sold'),
                'type'              => 'toggle',
                'value'             => true,
            ];
            $mark_sold_fields['owner_can_mark'] = [
                'label'             => __('Mark listing as Negotiating or Sold', 'directorist-mark-as-sold'),
                'description'       => __('Listing owner can mark listing as negotiating or sold from the dashboard', 'directorist-mark-as-sold'),
                'type'              => 'toggle',
                'value'             => true,
            ];

            $mark_sold_fields['auto_mark_by_contact'] = [
                'label'             => __('Automatically display Negotiating badge', 'directorist-mark-as-sold'),
                'description'       => __('Listing gets negotiating badge automatically after submitting the contact form', 'directorist-mark-as-sold'),
                'type'              => 'toggle',
                'value'             => true,
            ];

            $mark_sold_fields['hide_negotiating_from_public'] = [
                'label'             => __('Hide Negotiating listings from the search', 'directorist-mark-as-sold'),
                'type'              => 'toggle',
                'value'             => false,
            ];

            $mark_sold_fields['show_negotiation'] = [
                'label'     => __('Answer Field Type', 'directorist-faqs'),
                'type'      => 'select',
                'value'     => 'by_user',
                'options'   => [
                    [
                        'value' => 'immediately',
                        'label' => __('Immediately after submitting Contact form', 'directorist-mark-as-sold'),
                    ],
                    [
                        'value' => 'by_user',
                        'label' => __('User can mark item as Negotiating', 'directorist-mark-as-sold'),
                    ],
                    [
                        'value' => 'none',
                        'label' => __('Hide', 'directorist-mark-as-sold'),
                    ]
                ],
            ];
            $mark_sold_fields['display_sold_item'] = [
                'label'     => __('Display Sold Item', 'directorist-mark-as-sold'),
                'type'      => 'select',
                'value'     => 'both',
                'options'   => [
                    [
                        'value' => 'author_profile',
                        'label' => __('In author profile page only', 'directorist-mark-as-sold'),
                    ],
                    [
                        'value' => 'both',
                        'label' => __('In author profile and archive pages', 'directorist-mark-as-sold'),
                    ],
                    [
                        'value' => 'hide',
                        'label' => __('In user dashboard page only', 'directorist-mark-as-sold'),
                    ]
                ],
            ];
            $mark_sold_fields['sold_badge'] = [
                'type'              => 'text',
                'label'             => __('\'Sold\' Notification Text', 'directorist-mark-as-sold'),
                'value'             => __('Sold', 'directorist-mark-as-sold'),
            ];
            $mark_sold_fields['negotiation_badge'] = [
                'type'              => 'text',
                'label'             => __('\'Negotiation\' Notification Text', 'directorist-mark-as-sold'),
                'value'             => __('Negotiating', 'directorist-mark-as-sold'),
            ];

            return $mark_sold_fields;
        }

        public function atbdp_extension_settings_submenus( $submenu ) {
            $submenu['mark_sold'] = [
                'label' =>  __('Mark as Sold', 'directorist-mark-as-sold'),
                'icon'       => '<i class="fa fa-shopping-cart"></i>',
                'sections'   => apply_filters( 'atbdp_mark_sold_settings_controls', [
                    'general_section' => [
                        'title'       => __('Mark as Sold Settings', 'directorist-mark-as-sold'),
                        'description' => __('You can Customize all the settings of Mark as Sold Extension here', 'directorist-mark-as-sold'),
                        'fields'      =>  [ 'owner_can_mark', 'auto_mark_by_contact', 'hide_negotiating_from_public', 'display_sold_item', 'sold_badge', 'negotiation_badge' ],
                    ],
                ] ),
            ];

            return $submenu;
        }

        public function atbdp_listing_type_settings_field_list( $fields ){

            foreach( $fields as $key => $value ) {
                // setup widgets
                $sold_widget = [
                    'type' => "badge",
                    'id' => "sold_badge",
                    'label' => "Sold/Negotiating",
                    'icon' => "uil uil-text-fields",
                    'hook' => "atbdp_sold_badge",
                    'options' => [
                        'title' => "Sold Badge Settings",
                        'fields' => [
                            'icon' => [
                                'type' => "icon",
                                'label' => "Icon",
                                'value' => "fa fa-stack-exchange",
                            ],
                        ],
                    ],
                ];
                // setup widgets
                if( 'listings_card_grid_view' === $key  ) {
                    // register widget
                    $fields[$key]['card_templates']['grid_view_with_thumbnail']['widgets']['sold_badge'] = $sold_widget;
                    $fields[$key]['card_templates']['grid_view_without_thumbnail']['widgets']['sold_badge'] = $sold_widget;

                    // grid with preview image
                      array_push( $fields[$key]['card_templates']['grid_view_with_thumbnail']['layout']['thumbnail']['top_right']['acceptedWidgets'], 'sold_badge' );
                      array_push( $fields[$key]['card_templates']['grid_view_with_thumbnail']['layout']['thumbnail']['top_left']['acceptedWidgets'], 'sold_badge' );
                      array_push( $fields[$key]['card_templates']['grid_view_with_thumbnail']['layout']['thumbnail']['bottom_right']['acceptedWidgets'], 'sold_badge' );
                      array_push( $fields[$key]['card_templates']['grid_view_with_thumbnail']['layout']['thumbnail']['bottom_left']['acceptedWidgets'], 'sold_badge' );
                      array_push( $fields[$key]['card_templates']['grid_view_with_thumbnail']['layout']['body']['top']['acceptedWidgets'], 'sold_badge' );

                      // grid without preview image
                      array_push( $fields[$key]['card_templates']['grid_view_without_thumbnail']['layout']['body']['quick_info']['acceptedWidgets'], 'sold_badge' );
                    }

                    if( 'listings_card_list_view' === $key ) {
                        // register widget
                        $fields[$key]['card_templates']['list_view_with_thumbnail']['widgets']['sold_badge'] = $sold_widget;
                        $fields[$key]['card_templates']['list_view_without_thumbnail']['widgets']['sold_badge'] = $sold_widget;

                        // grid with preview image
                        array_push( $fields[$key]['card_templates']['list_view_with_thumbnail']['layout']['thumbnail']['top_right']['acceptedWidgets'], 'sold_badge' );
                        array_push( $fields[$key]['card_templates']['list_view_with_thumbnail']['layout']['body']['top']['acceptedWidgets'], 'sold_badge' );
                        array_push( $fields[$key]['card_templates']['list_view_with_thumbnail']['layout']['body']['right']['acceptedWidgets'], 'sold_badge' );

                        // grid without preview image
                        array_push( $fields[$key]['card_templates']['list_view_without_thumbnail']['layout']['body']['top']['acceptedWidgets'], 'sold_badge' );
                        array_push( $fields[$key]['card_templates']['list_view_without_thumbnail']['layout']['body']['right']['acceptedWidgets'], 'sold_badge' );
                }
            }
            return $fields;
        }


        /**
         * @param $queries
         * @return mixed
         * @since 1.0.0
         */

        public function pyn_author_custom_meta_queries($queries)
        {
            $display_sold_item = get_directorist_option('display_sold_item', 'both');
            if (('author_profile' === $display_sold_item) || ('both' === $display_sold_item)) {
                return $queries;
            } else {
                $sub_meta_queries = array();
                $sub_meta_queries[] = array(
                    'key' => '_negotiate',
                    'value' => 'sold',
                    'compare' => '!=',
                );
                $sub_meta_queries[] = array(
                    'key' => '_negotiate',
                    'compare' => 'NOT EXISTS',
                );
                $meta_queries[] = array_merge(array('relation' => 'OR'), $sub_meta_queries);
                array_push($queries, $meta_queries);
                return $queries;
            }

        }

        public function pyn_custom_meta_queries($queries)
        {
            $hide_negotiating_from_public   = get_directorist_option('hide_negotiating_from_public', false);
            $display_sold_item              = get_directorist_option('display_sold_item', 'both');
            
            if( $hide_negotiating_from_public ) {
                $sub_meta_queries = array();
                $sub_meta_queries[] = array(
                    'key' => '_negotiate',
                    'value' => 'yes',
                    'compare' => '!=',
                );
                $sub_meta_queries[] = array(
                    'key' => '_negotiate',
                    'compare' => 'NOT EXISTS',
                );
                $meta_queries[] = array_merge(array('relation' => 'OR'), $sub_meta_queries);
                array_push($queries, $meta_queries);
            }


            if ( 'both' !== $display_sold_item ) {
                $sub_meta_queries = array();
                $sub_meta_queries[] = array(
                    'key' => '_negotiate',
                    'value' => 'sold',
                    'compare' => '!=',
                );
                $sub_meta_queries[] = array(
                    'key' => '_negotiate',
                    'compare' => 'NOT EXISTS',
                );
                $meta_queries[] = array_merge(array('relation' => 'OR'), $sub_meta_queries);
                array_push($queries, $meta_queries);
               
            }
            return $queries;

        }

        /**
         * @since 1.0
         */
        public function atbdp_grid_lower_badges($default)
        {
            $page = get_directorist_option('author_profile_page');
            $display_sold_item = get_directorist_option('display_sold_item', 'both');
            if ((get_queried_object_id() === (int)$page) || ('both' === $display_sold_item)) {
                $sold_badge = get_directorist_option('sold_badge', __('Sold', 'directorist-mark-as-sold'));
                $is_negotiated = get_post_meta(get_the_ID(), '_negotiate', true);
                if ('sold' === $is_negotiated) {
                    ?>
                    <div class="atbd_lower_badge">
               <span class="atbd_badge atbd_badge_sold">
                   <?php echo $sold_badge; ?>
               </span>
                    </div>
                    <?php
                }else{
                    return $default;
                }
            } else {
                return $default;
            }
        }

        /**
         * @since 1.0
         */
        public function atbdp_after_user_dashboard_upper_badge($post_id)
        {
            $sold_badge = get_directorist_option('sold_badge', __('Sold', 'directorist-mark-as-sold'));
            $is_negotiated = get_post_meta($post_id, '_negotiate', true);
            if ('sold' === $is_negotiated) {
                ?>
                <div class="atbd_lower_badge">
               <span class="atbd_badge atbd_badge_sold">
                   <?php echo $sold_badge; ?>
               </span>
                </div>
                <?php
            }
        }

        /**
         * @since 1.0
         */
        public function mas_user_dashboard_action()
        {
            $data = array();
            $post_id = isset($_POST['post_id']) ? (int)$_POST['post_id'] : '';
            $action_type = isset($_POST['action_type']) ? $_POST['action_type'] : '';
            $negotiate = get_post_meta($post_id, '_negotiate', true);
            /*if (('negotiate' === $action_type) && ('by_user' === $negotiate)) {
                $update = update_post_meta($post_id, '_negotiate', 'yes');
                if ($update) {
                    $data['message'] = sprintf(__('Listing has mark as negotiated', 'directorist-mark-as-sold'));
                }
            } else {
                if (('yes' === $negotiate) && ('sold' !== $action_type)) {
                    $update = update_post_meta($post_id, '_negotiate', '');
                    if ($update) {
                        $data['message'] = sprintf(__('Listing has unmark from negotiation', 'directorist-mark-as-sold'));
                    }
                } else {
                    if ('sold' === $negotiate) {
                        $update = update_post_meta($post_id, '_negotiate', '');
                        $data['message'] = sprintf(__('Listing has unmark from sold', 'directorist-mark-as-sold'));
                    } else {
                        $update = update_post_meta($post_id, '_negotiate', $action_type);
                        $data['message'] = sprintf(__('Listing has mark as sold', 'directorist-mark-as-sold'));
                    }
                }

            }*/

            if ('negotiate' === $action_type) {
                if ('yes' === $negotiate) {
                    $update = update_post_meta($post_id, '_negotiate', '');
                    $data['message'] = sprintf(__('Listing has unmarked from negotiation', 'directorist-mark-as-sold'));
                    $data['action_response'] = 'unmarked';
                } else {
                    $update = update_post_meta($post_id, '_negotiate', 'yes');
                    $data['message'] = sprintf(__('Listing has marked as negotiated', 'directorist-mark-as-sold'));
                    $data['action_response'] = 'marked';
                }
            } else {
                if ('sold' === $negotiate) {
                    $update = update_post_meta($post_id, '_negotiate', '');
                    $data['message'] = sprintf(__('Listing has unmarked from sold', 'directorist-mark-as-sold'));
                    $data['action_response'] = 'unmarked';
                } else {
                    $update = update_post_meta($post_id, '_negotiate', $action_type);
                    $data['message'] = sprintf(__('Listing has marked as sold', 'directorist-mark-as-sold'));
                    $data['action_response'] = 'marked';

                }
            }

            if ($update) {
                $data['id'] = $post_id;
                //$data['message'] = sprintf(__('Listing has mark as %s', 'directorist-mark-as-sold'), $action_type);
                $data['action_type'] = $action_type;
                wp_send_json($data);
                die();
            }

        }

        /**
         * @since 1.0
         */
        public function mas_license_settings_controls($default)
        {
            $status = get_option('directorist_mark_as_sold_license_status');
            if (!empty($status) && ($status !== false && $status == 'valid')) {
                $action = array(
                    'type' => 'toggle',
                    'name' => 'mark_as_sold_deactivated',
                    'label' => __('Action', 'directorist-mark-as-sold'),
                    'validation' => 'numeric',
                );
            } else {
                $action = array(
                    'type' => 'toggle',
                    'name' => 'mark_as_sold_activated',
                    'label' => __('Action', 'directorist-mark-as-sold'),
                    'validation' => 'numeric',
                );
            }
            $new = apply_filters('atbdp_mark_as_sold_license_controls', array(
                'type' => 'section',
                'title' => __('Mark as Sold', 'directorist-business-hours'),
                'description' => __('You can active your Mark as Sold extension here.', 'directorist-business-hours'),
                'fields' => apply_filters('atbdp_mark_as_sold_license_settings_field', array(
                    array(
                        'type' => 'textbox',
                        'name' => 'mark_as_sold_license',
                        'label' => __('License', 'directorist-mark-as-sold'),
                        'description' => __('Enter your Mark as Sold extension license', 'directorist-mark-as-sold'),
                        'default' => '',
                    ),
                    $action
                )),
            ));
            $settings = apply_filters('atbdp_licence_menu_for_mark_as_sold', true);
            if($settings){
                array_push($default, $new);
            }
            return $default;
        }


        /**
         * @since 1.0
         */
        public function load_admin_needed_scripts()
        {
            wp_register_script('mas_main__admin_js', plugin_dir_url(__FILE__) . 'assets/admin/js/main.js');
            wp_enqueue_style('mas_main__admin_css', plugin_dir_url(__FILE__) . 'assets/admin/css/main.css');
            wp_enqueue_script('mas_main__admin_js');
            $data = array(
                'ajaxurl' => admin_url('admin-ajax.php'),
            );
            wp_localize_script('mas_main__admin_js', 'mas_main__admin_js', $data);
        }

        /**
         * @since 1.0
         */
        public function load_needed_scripts()
        {
            wp_register_style('mas_main__public_style', plugin_dir_url(__FILE__) . 'assets/public/css/main.css');
            wp_register_script('mas_main__public_js', plugin_dir_url(__FILE__) . 'assets/public/js/main.js', [], time(), true);
            wp_enqueue_style('mas_main__public_style');
            wp_enqueue_script('mas_main__public_js');
            $data = array(
                'ajaxurl' => admin_url('admin-ajax.php'),
            );
            wp_localize_script('mas_main__public_js', 'mas_main_js', $data);
        }

        /**
         * @since 1.0
         */
        public function atbdp_user_dashboard_before_button($post_id)
        {
            $show_negotiation = get_directorist_option('show_negotiation', 'by_user');
            $is_negotiated = get_post_meta($post_id, '_negotiate', true);
            //if (('yes' === $is_negotiated) || ('sold' === $is_negotiated) || ('by_user' === $is_negotiated) || ('none' === $is_negotiated)) {

            echo '<div class="atbdp-mark-as-sold">';
            //if (('by_user' === $show_negotiation) || ('yes' === $is_negotiated)) {
            ?>
            <p>
                <input type="checkbox" id="negotiate_<?php echo $post_id; ?>" class="mas_user_decision"
                       data-action="negotiate"
                       data-listing-id="<?php echo $post_id; ?>" <?php echo ('yes' === $is_negotiated) ? 'checked' : '' ?>>
                <label for="negotiate_<?php echo $post_id; ?>"><?php _e('Mark as Negotiating', 'directorist-mark-as-sold'); ?></label>
            </p>
            <?php //}
            ?>
            <p>
                <input type="checkbox" id="sold_<?php echo $post_id; ?>" class="mas_user_decision"
                       data-action="sold"
                       data-listing-id="<?php echo $post_id; ?>" <?php echo ('sold' === $is_negotiated) ? 'checked' : '' ?>>
                <label for="sold_<?php echo $post_id; ?>"><?php _e('Mark as Sold', 'directorist-mark-as-sold'); ?></label>
            </p>
            <div id="directorist-mas-notifier_<?php echo $post_id; ?>" class="directorist-mas-notifier"></div>
            <?php
            echo '</div>';
            //}
        }

        /**
         * @since 1.0
         */
        public function atbdp_listing_price($default)
        {
            $negotiation_badge = get_directorist_option('negotiation_badge', __('Negotiating', 'directorist-mark-as-sold'));
            $is_negotiated = get_post_meta(get_the_ID(), '_negotiate', true);
            if ('yes' === $is_negotiated) {
                return sprintf("<span class='atbd_meta atbd_listing_price'>%s</span>", $negotiation_badge);
            } else {
                return $default;
            }
        }

        /**
         * @since 1.0
         */
        public function atbdp_listing_contact_owner_submitted()
        {
            $post_id = isset($_POST['post_id']) ? sanitize_text_field( $_POST['post_id'] ): '';
            $auto_mark_by_contact   = get_directorist_option( 'auto_mark_by_contact', true);

            if ( $auto_mark_by_contact ) {
                update_post_meta( $post_id, '_negotiate', 'yes' );
            }
        }

        /**
         * It register the text domain to the WordPress
         */
        public function load_textdomain()
        {
            load_plugin_textdomain('directorist-mark-as-sold', false, dirname(plugin_basename(__FILE__)) . '/languages');
        }

        public static function get_version_from_file_content( $file_path = '' ) {
            $version = '';

            if ( ! file_exists( $file_path ) ) {
                return $version;
            }

            $content = file_get_contents( $file_path );
            $version = self::get_version_from_content( $content );

            return $version;
        }

        public static function get_version_from_content( $content = '' ) {
            $version = '';

            if ( preg_match('/\*[\s\t]+?version:[\s\t]+?([0-9.]+)/i', $content, $v) ) {
                $version = $v[1];
            }

            return $version;
        }

        /**
         * It Includes and requires necessary files.
         *
         * @access private
         * @return void
         * @since 1.0
         */
        private function setup_constants()
        {
            // Plugin version
            if (!defined('MAS_VERSION')) {
                define('MAS_VERSION', self::get_version_from_file_content( __FILE__ ) );
            }
            // plugin author url
            if (!defined('ATBDP_AUTHOR_URL')) {
                define('ATBDP_AUTHOR_URL', 'https://directorist.com');
            }
            // post id from download post type (edd)
            if (!defined('ATBDP_MAS_POST_ID')) {
                define('ATBDP_MAS_POST_ID', 20204);
            }
        }

        /**
         * It Includes and requires necessary files.
         *
         * @access private
         * @return void
         * @since 1.0
         */
        private function includes()
        {
            // setup the updater
            if (!class_exists('EDD_SL_Plugin_Updater')) {
                // load our custom updater if it doesn't already exist
                include(dirname(__FILE__) . '/includes/EDD_SL_Plugin_Updater.php');
            }
            $license_key = trim(get_option('directorist_mark_as_sold_license'));
            new EDD_SL_Plugin_Updater(ATBDP_AUTHOR_URL, __FILE__, array(
                'version' => MAS_VERSION,        // current version number
                'license' => $license_key,    // license key (used get_option above to retrieve from DB)
                'item_id' => ATBDP_MAS_POST_ID,    // id of this plugin
                'author' => 'AazzTech',    // author of this plugin
                'url' => home_url(),
                'beta' => false // set to true if you wish customers to receive update notifications of beta releases
            ));
        }

        private function __construct()
        {
            /*making it private prevents constructing the object*/
        }

        public function __clone()
        {
            // Cloning instances of the class is forbidden.
            _doing_it_wrong(__FUNCTION__, __('Cheatin&#8217; huh?'), '1.0');
        }

        public function __wakeup()
        {
            // Unserializing instances of the class is forbidden.
            _doing_it_wrong(__FUNCTION__, __('Cheatin&#8217; huh?'), '1.0');
        }

    }

    if ( ! function_exists( 'directorist_is_plugin_active' ) ) {
        function directorist_is_plugin_active( $plugin ) {
            return in_array( $plugin, (array) get_option( 'active_plugins', array() ), true ) || directorist_is_plugin_active_for_network( $plugin );
        }
    }

    if ( ! function_exists( 'directorist_is_plugin_active_for_network' ) ) {
        function directorist_is_plugin_active_for_network( $plugin ) {
            if ( ! is_multisite() ) {
                return false;
            }

            $plugins = get_site_option( 'active_sitewide_plugins' );
            if ( isset( $plugins[ $plugin ] ) ) {
                    return true;
            }

            return false;
        }
    }

    /**
     * The main function for that returns Directorist_Mark_as_Sold
     *
     * The main function responsible for returning the one true Directorist_Mark_as_Sold
     * Instance to functions everywhere.
     *
     * Use this function like you would a global variable, except without needing
     * to declare the global.
     *
     *
     * @return object|Directorist_Mark_as_Sold The one true Directorist_Mark_as_Sold Instance.
     * @since 1.0
     */
    function Directorist_Mark_as_Sold()
    {
        return Directorist_Mark_as_Sold::instance();
    }

    if ( directorist_is_plugin_active( 'directorist/directorist-base.php' ) ) {
        Directorist_Mark_as_Sold(); // get the plugin running
    }
}
