(function ($) {
    $(document).ready(function () {
        // activate license and set up updated
        $('#mark_as_sold_activated input[name="mark_as_sold_activated"]').on('change', function (event) {
            event.preventDefault();
            var form_data = new FormData();
            var mark_as_sold_license = $('#mark_as_sold_license input[name="mark_as_sold_license"]').val();
            form_data.append('action', 'atbdp_mark_as_sold_license_activation');
            form_data.append('mark_as_sold_license', mark_as_sold_license);
            $.ajax({
                method: 'POST',
                processData: false,
                contentType: false,
                url: mas_main__admin_js.ajaxurl,
                data: form_data,
                success: function (response) {
                    if (response.status === true) {
                        $('#success_msg').remove();
                        $('#mark_as_sold_activated').after('<p id="success_msg">' + response.msg + '</p>');
                        location.reload();
                    } else {
                        $('#error_msg').remove();
                        $('#mark_as_sold_activated').after('<p id="error_msg">' + response.msg + '</p>');
                    }
                },
                error: function (error) {
                    // console.log(error);
                }
            });
        });
        // deactivate license
        $('#mark_as_sold_deactivated input[name="mark_as_sold_deactivated"]').on('change', function (event) {
            event.preventDefault();
            var form_data = new FormData();
            var mark_as_sold_license = $('#mark_as_sold_license input[name="mark_as_sold_license"]').val();
            form_data.append('action', 'atbdp_mark_as_sold_license_deactivation');
            form_data.append('mark_as_sold_license', mark_as_sold_license);
            $.ajax({
                method: 'POST',
                processData: false,
                contentType: false,
                url: mas_main__admin_js.ajaxurl,
                data: form_data,
                success: function (response) {
                    if (response.status === true) {
                        $('#success_msg').remove();
                        $('#mark_as_sold_deactivated').after('<p id="success_msg">' + response.msg + '</p>');
                        location.reload();
                    } else {
                        $('#error_msg').remove();
                        $('#mark_as_sold_deactivated').after('<p id="error_msg">' + response.msg + '</p>');
                    }
                },
                error: function (error) {
                    // console.log(error);
                }
            });
        });

    });
})(jQuery);