<?php
/**
 * Base class for loading all assets.
 *
 * @author wpWax
 */

namespace Directorist_BH;

use Directorist\Asset_Loader\Helper as Directorist_Asset_Helper;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Asset_Loader {

	protected static $instance = null;

	/**
	 * Initialize
	 *
	 * @return void
	 */
	public function __construct() {
		// Frontend scripts
		add_action( 'wp_enqueue_scripts', array( $this, 'register_scripts' ) );
		add_action( 'wp_enqueue_scripts', array( $this , 'enqueue_styles' ), 12 );
		add_action( 'wp_enqueue_scripts', array( $this , 'localized_data' ), 15 );

		// Admin Scripts
		add_action( 'admin_enqueue_scripts', array( $this, 'register_scripts' ) );
		add_action( 'admin_enqueue_scripts', array( $this, 'admin_scripts' ), 12 );
		add_action( 'admin_enqueue_scripts', array( $this, 'localized_data' ), 15 );

		// Enqueue conditional scripts depending on loaded template
		add_action( 'directorist_bh_before_template_loaded', array( $this, 'load_template_scripts' ) );
		add_action( 'directorist_bh_before_widgets_loaded', array( $this, 'load_template_scripts' ) );
	}

	public static function instance() {
		if ( null == self::$instance ) {
			self::$instance = new self;
		}

		return self::$instance;
	}

	public function enqueue_styles() {
		wp_enqueue_style( 'bdbh_main_style' );
	}

	public function load_template_scripts() {
		wp_enqueue_script( 'bdbh_main_script' );
	}

	public function admin_scripts() {
		if ( Directorist_Asset_Helper::is_admin_page( 'add_listing' ) ) {
			wp_enqueue_style( 'bdbh_main_style' );
			wp_enqueue_script( 'bdbh_main_script' );
		}
	}

	public function localized_data() {
		$data = array(
			'ajaxurl'                    => admin_url( 'admin-ajax.php' ),
			'cache_plugin_compatibility' => get_directorist_option( 'cache_plugin_compatibility', false ),
		);
		wp_localize_script( 'bdbh_main_script', 'atbdp_business_hours', $data );
	}

	/**
	* Scripts array.
	*
	* Each item may contain following arguments:
	* 		$scripts['handle'] => [
	*			'type' => String, // Accepts css, js
	*			'path' => String, // Absolute url, without the min/rtl/js extension
	*			'ext'  => String, // External url, in case the path is absent
	*			'dep'  => Array [], // Dependency list eg. [jquery]
	*			'rtl'  => Boolean false, // RTL exists or not
	*		];
	*/
	public function get_all_scripts() {
		$css_path = BDBH_ASSETS . 'css/';
		$js_path  = BDBH_ASSETS . 'js/';
		$scripts  = array(
			'bdbh_main_style' => array(
				'type' => 'css',
				'rtl'  => true,
				'path' => $css_path . 'main',
			),
			'bdbh_main_script' => array(
				'type' => 'js',
				'path' => $js_path . 'main',
			),
		);
		return $scripts;
	}

	public function register_scripts() {
		$scripts = $this->get_all_scripts();
		$version = Directorist_Asset_Helper::debug_enabled() ? time() : BDBH_VERSION;
		Directorist_Asset_Helper::register_all_scripts( $scripts, $version );
	}
}
