<?php
/**
 * Directorist BP message butotn template for single view.
 * 
 * Available template data -
 * $listing - Current listing object.
 * $data - current field config data.
 * 
 * 
 * @package Directorist_BuddyPress_Integration
 */

defined( 'ABSPATH' ) || die();

// Only logged in users can see the button and message the listing owner.
// BuddyPress doesn't allow non logged in users to send message.
if ( ! is_user_logged_in() || ! bp_is_active( 'messages' ) ) {
    return;
}

$classes = array(
    'directorist-btn directorist-btn-primary directorist-btn-sm dbp-btn--single',
    'bp-message-button bp-message-button-' . $listing->id,
);

$label = ! empty( $data['text'] ) ? $data['text'] : '';
$icon  = ! empty( $data['icon'] ) ? $data['icon'] : '';

if ( $icon && ! $label ) {
    $label = directorist_icon( $icon, false );
} elseif ( $icon && $label ) {
    $label = directorist_icon( $icon, false ) . ' ' . esc_html( $label );
}

$user_id = get_post_field( 'post_author', $listing->id );
?>
<a href="<?php echo dbp_get_send_message_link( $user_id ); ?>" class="<?php echo esc_attr( implode( ' ', $classes ) ); ?>"><?php echo $label; ?></a>
