<?php
/**
 * Directorist BP message butotn template for archive view.
 * 
 * Available template data -
 * $listings - Current listing object.
 * $post_id - current listing id.
 * $data - current field config data.
 * 
 * 
 * @package Directorist_BuddyPress_Integration
 */

defined( 'ABSPATH' ) || die();

// $data = array (
//     'type' => 'button',
//     'id' => 'bp_message_button',
//     'label' => 'BuddyPress Message',
//     'hook' => 'atbdp_open_close_badge',
//     'widget_name' => 'bp_message_button',
//     'widget_key' => 'bp_message_button',
//     'value' => 'Send Message',
// )

// Only logged in users can see the button and message the listing owner.
// BuddyPress doesn't allow non logged in users to send message.
if ( ! is_user_logged_in() || ! bp_is_active( 'messages' ) ) {
    return;
}

$classes = array(
    'dbp-btn--archive',
    'bp-message-button bp-message-button-' . $post_id,
);

$label = ! empty( $data['text'] ) ? $data['text'] : '';
$icon  = ! empty( $data['icon'] ) ? $data['icon'] : '';

if ( $icon && ! $label ) {
    $label = directorist_icon( $icon, false );
} elseif ( $icon && $label ) {
    $label = directorist_icon( $icon, false ) . ' ' . esc_html( $label );
}

$user_id = get_post_field( 'post_author', $post_id );
?>
<a href="<?php echo dbp_get_send_message_link( $user_id ); ?>" class="<?php echo esc_attr( implode( ' ', $classes ) ); ?>"><?php echo $label; ?></a>
