<?php
/**
 * BP profile favorites template.
 * 
 * @package Directorist_BuddyPress_Integration
 */

defined( 'ABSPATH' ) || die();

do_action( 'bp_before_member_' . bp_current_action() . '_content' ); ?>

<?php
$user_favourites = get_user_meta( bp_displayed_user_id(), 'atbdp_favourites', true );

if ( bp_is_my_profile() ) {
	$message = __( 'You do not have any favorite listings yet.', 'directorist-buddypress-integration' );
} else {
	$name = bp_core_get_user_displayname( bp_displayed_user_id() );
	$message = sprintf( __( '%1$s does not have any favorite yet.', 'directorist-buddypress-integration' ), $name );
}

if ( empty( $user_favourites ) || ! is_array( $user_favourites ) ) : ?>

	<p class="directorist-favorites-not-found"><em><?php echo $message; ?></em></p>

<?php else :

	$args = array(
		'orderby'             => 'date',
		'order'               => 'DESC',
		'view'                => get_directorist_option( 'bp_my_listings_view', 'grid' ),
		'advanced_filter'     => 'no',
		'logged_in_user_only' => 'no',
		'listings_per_page'   => get_directorist_option( 'bp_my_listings_per_page', 6 ),
		'ids'                 => implode( ',', $user_favourites ),
	);
	
	echo dbp_run_shortcode_callback( 'directorist_all_listing', $args );

endif;
?>

<?php do_action( 'bp_after_member_' . bp_current_action() . '_content' ); ?>
