<?php
/**
 * Listings common functions.
 * 
 * Define functions that are globally accessible in all listigns files.
 */
defined( 'ABSPATH' ) || die();

/**
 * Check add listings shareing is enabled in admin settings.
 *
 * @return bool
 */
function dbp_is_admin_add_listing_sharing_enabled() {
	return (bool) get_directorist_option( 'enable_add_listing_sharing', true );
}

/**
 * Check notification is enabled in admin settings.
 *
 * @return bool
 */
function dbp_is_admin_notification_enabled() {
	return (bool) get_directorist_option( 'enable_notification', true );
}

/**
 * Check add favorite sharing is enabled in admin settings.
 *
 * @return bool
 */
function dbp_is_admin_add_favorite_sharing_enabled() {
	return (bool) get_directorist_option( 'enable_add_favorite_sharing', true );
}

/**
 * Check listings sharing is enabled in admin settings.
 *
 * @return bool
 */
function dbp_is_admin_listing_sharing_enabled() {
	return (bool) get_directorist_option( 'enable_listing_sharing', true );
}

/**
 * Check group listings is enabled in admin settings.
 *
 * @return bool
 */
function dbp_is_admin_group_listings_enabled() {
	return (bool) get_directorist_option( 'enable_group_listings', false );
}

function dbp_listings_dropdown( $args = array() ) {
	$args = wp_parse_args( $args, array(
		'class'       => '',
		'id'          => '',
		'value'       => array(),
		'name'        => 'directorist_listings_dropdown',
		'placeholder' => __( 'Type and select...', 'directorist-buddypress-integration' ),
	) );

	$query_args = array(
		'post_type'              => ATBDP_POST_TYPE,
		'post_status'            => 'publish',
		'orderby'                => 'date',
		'order'                  => 'DESC',
		'posts_per_page'         => 10,
		'no_found_rows'          => true,
		'update_post_meta_cache' => false,
		'update_post_term_cache' => false,
	);

	$selected = false;

	if ( ! empty( $args['value'] ) ) {
		$query_args['orderby']        = 'post__in';
		$query_args['post__in']       = $args['value'];
		$query_args['posts_per_page'] = count( $args['value'] );
		$selected = true;
	}

	$query    = new WP_Query( $query_args );
	$listings = $query->have_posts() ? $query->posts : array();

	?>
	<select
		style="width:100%"
		name="<?php echo esc_attr( $args['name'] ); ?>[]"
		id="<?php echo esc_attr( $args['id'] ); ?>"
		class="<?php echo esc_attr( $args['class'] ); ?>"
		multiple="multiple"
		data-placeholder="<?php echo esc_attr( $args['placeholder'] ); ?>">
		<?php
		if ( ! empty( $listings ) ) :
			foreach ( $listings as $listing ) : ?>
				<option <?php echo $selected ? 'selected="selected"' : ''; ?> value="<?php echo esc_attr( $listing->ID ); ?>"><?php echo esc_html( $listing->post_title ); ?></option>
			<?php endforeach; ?>
		<?php else : ?>
			<option value=""><?php echo esc_attr( $args['placeholder'] ); ?></option>
		<?php endif; ?>
	</select>
	<?php
}

/**
 * Count user listings.
 * 
 * @param int $user_id
 * 
 * @return int
 */
function dbp_count_user_listings( $user_id = 0 ) {
	global $wpdb;

	$sql = "SELECT COUNT(*) FROM $wpdb->posts WHERE post_type = '%s' AND post_status = 'publish' AND post_author = %d";

	$count = $wpdb->get_var( $wpdb->prepare( $sql, ATBDP_POST_TYPE, $user_id ) );

	return $count;
}

function dbp_get_send_message_link( $user_id ) {
	if ( ! is_user_logged_in() ) {
		return;
	}

	$url = add_query_arg( array(
		'r' => bp_core_get_username( $user_id ),
	), trailingslashit( bp_loggedin_user_domain() . bp_get_messages_slug() . '/compose' ) );
	
	return esc_url( wp_nonce_url( $url ) );
}
