<?php
/**
 * Directorist BuddyPress template class.
 * 
 * @package wpWax\Directorist\BuddyPress
 * @since Directorist\BuddyPress 1.0.0
 */
namespace wpWax\Directorist\BuddyPress;

defined( 'ABSPATH' ) || die();

class Template {

	public static function init() {
		add_filter( 'directorist_template_file_path', array( __CLASS__, 'add_template_file_path' ), 10, 2 );

		add_action( 'wp_enqueue_scripts', array( __CLASS__, 'add_styles' ) );
	}

	public static function add_styles() {
		$data = <<<STYLE
		.dbp-btn--single {
			margin-top: 20px;
			margin-bottom: 20px;
		}
		.dbp-btn--archive {
			color: #767792;
			padding-left: 5px;
			padding-right: 5px;
		}
STYLE;
		wp_add_inline_style(
			'directorist-main-style',
			$data
		);
	}

	public static function add_template_file_path( $file_path, $template_file ) {
		if ( 'archive/fields/bp_message_button' === $template_file ) {
			$_template_file = directorist_buddypress()->template_dir . 'directorist/archive-message-button.php';

			if ( is_readable( $_template_file ) ) {
				$file_path = $_template_file;
			}
		}

		if ( 'single/fields/bp_message_button' === $template_file ) {
			$_template_file = directorist_buddypress()->template_dir . 'directorist/single-message-button.php';

			if ( is_readable( $_template_file ) ) {
				$file_path = $_template_file;
			}
		}

		return $file_path;
	}
}

Template::init();
