<?php
/**
 * Directorist BuddyPress settings panel.
 * 
 * @package wpWax\Directorist\BuddyPress
 * @since Directorist\BuddyPress 1.0.0
 */
namespace wpWax\Directorist\BuddyPress;

defined( 'ABSPATH' ) || die();

class Settings {

	public static function init() {
		add_action( 'atbdp_listing_type_settings_layout', array( __CLASS__, 'register_panel' ) );
		add_filter( 'atbdp_listing_type_settings_field_list', array( __CLASS__, 'register_fields' ) );
	}

	protected static function get_my_profile_fields() {
		return array(
			'enable_add_listing_sharing' => array(
				'type'        => 'toggle',
				'label'       => __( 'Add Listing Sharing', 'directorist-buddypress-integration' ),
				'description' => __( 'Allow users to share activity update on timeline when the user creates a new listing.', 'directorist-buddypress-integration' ),
				'value'       => true,
			),
			'enable_listing_sharing' => array(
				'type'        => 'toggle',
				'label'       => __( 'Allow Listing Sharing', 'directorist-buddypress-integration' ),
				'description' => __( 'Allow users to share a single listing on their timeline from single listing view.', 'directorist-buddypress-integration' ),
				'value'       => true,
			),
			'bp_listing_sharing_text' => array(
				'type'        => 'text',
				'label'       => __( 'Share Button Text', 'directorist-buddypress-integration' ),
				'description' => __( 'Update listing sharing button text from here.', 'directorist-buddypress-integration' ),
				'value'       => __( 'On Timeline', 'directorist-buddypress-integration' ),
			),
			'bp_my_listings_view' => array(
				'type'        => 'select',
				'label'       => __( 'My Listings Default View', 'directorist-buddypress-integration' ),
				'description' => __( 'Select a default layout view for my listings (My Listings & Favorites).', 'directorist-buddypress-integration' ),
				'value'       => 'grid',
				'options'     => array(
					array(
						'value' => 'grid',
						'label' => __( 'Grid View', 'directorist-buddypress-integration' ),
					),
					array(
						'value' => 'list',
						'label' => __( 'List View', 'directorist-buddypress-integration' ),
					),
					array(
						'value' => 'map',
						'label' => __( 'Map View', 'directorist-buddypress-integration' ),
					),
				),
			),
			'bp_my_listings_per_page' => array(
				'type'        => 'number',
				'label'       => __( 'Listings Per Page', 'directorist-buddypress-integration' ),
				'description' => __( 'Set the number of listings to show at a time. Keep it low (3-12) to load the page faster.', 'directorist-buddypress-integration' ),
				'value'       => 6,
				'min'         => 1,
				'max'         => 20,
			),
		);
	}

	public static function get_group_listings_fields() {
		return array(
			'enable_group_listings' => array(
				'type'        => 'toggle',
				'label'       => __( 'Enable Group Directory Listings', 'directorist-buddypress-integration' ),
				'description' => __( 'Group admin will get the access to create directory listings.', 'directorist-buddypress-integration' ),
				'value'       => false,
			),
			'bp_group_listings_view' => array(
				'type'        => 'select',
				'label'       => __( 'Listings Default View', 'directorist-buddypress-integration' ),
				'description' => __( 'Select a default layout view for group directory listings.', 'directorist-buddypress-integration' ),
				'value'       => 'grid',
				'options'     => array(
					array(
						'value' => 'grid',
						'label' => __( 'Grid View', 'directorist-buddypress-integration' ),
					),
					array(
						'value' => 'list',
						'label' => __( 'List View', 'directorist-buddypress-integration' ),
					),
					array(
						'value' => 'map',
						'label' => __( 'Map View', 'directorist-buddypress-integration' ),
					),
				),
			),
			'bp_group_listings_per_page' => array(
				'type'        => 'number',
				'label'       => __( 'Listings Per Page', 'directorist-buddypress-integration' ),
				'description' => __( 'Set the number of listings to show at a time. Keep it low (3-12) to load the page faster.', 'directorist-buddypress-integration' ),
				'value'       => 6,
				'min'         => 1,
				'max'         => 20,
			),
		);
	}

	public static function get_page_redirection_fields() {
		return array(
			'redirect_login_to_bb_login' => array(
				'type'        => 'toggle',
				'label'       => __( 'Login Redirect', 'directorist-buddypress-integration' ),
				'description' => __( 'Redirect Directorist login page to default login page.', 'directorist-buddypress-integration' ),
				'value'       => true,
			),
			'redirect_registration_to_bb_registration' => array(
				'type'        => 'toggle',
				'label'       => __( 'Registration Redirect', 'directorist-buddypress-integration' ),
				'description' => __( 'Redirect Directorist registration page to default registration page.', 'directorist-buddypress-integration' ),
				'value'       => true,
			),
		);
	}

	public static function register_fields( $fields ) {
		return array_merge(
			$fields,
			self::get_my_profile_fields(),
			self::get_group_listings_fields(),
			self::get_page_redirection_fields()
		);
	}

	public static function register_panel( $layout ) {
		$layout['extension_settings']['submenu']['buddypress-integration'] = array(
			'label' => __( 'BuddyPress', 'directorist-buddypress-integration' ),
			'icon' => '<i class="fa fa-circle"></i>',
			'sections' => array(
				'my_profile_settings' => array(
					'title' => __( 'User Profile', 'directorist-buddypress-integration' ),
					'fields' => array_keys( self::get_my_profile_fields() )
				),
				'group_listings_settings' => array(
					'title' => __( 'Group Directory', 'directorist-buddypress-integration' ),
					'fields' => array_keys( self::get_group_listings_fields() )
				),
				'page_directions' => array(
					'title' => __( 'Pages', 'directorist-buddypress-integration' ),
					'fields' => array_keys( self::get_page_redirection_fields() )
				)
			),
		);

		return $layout;
	}
}

Settings::init();
