<?php
/**
 * Directorist BuddyPress builder panel.
 * 
 * @package wpWax\Directorist\BuddyPress
 * @since Directorist\BuddyPress 1.0.0
 */
namespace wpWax\Directorist\BuddyPress;

defined( 'ABSPATH' ) || die();

class Builder {

	public static function init() {
		add_filter( 'atbdp_listing_type_settings_field_list', array( __CLASS__, 'register_archive_fields' ) );
		add_filter( 'atbdp_single_listing_other_fields_widget', array( __CLASS__, 'register_single_fields' ) );
	}

	public static function register_single_fields( $fields ) {
		if ( ! bp_is_active( 'messages' ) ) {
			return $fields;
		}

		$fields['bp_message_button'] = [ 
			'type'          => 'widget',
			'label'         => __( 'BuddyPress Message', 'directorist-buddypress-integration' ),
			'icon'          => 'uil uil-envelope',
			'allowMultiple' => false,
			'options'       => [
				'text' => array(
					'type'  => 'text',
					'label' => __( 'Button Text', 'directorist-buddypress-integration' ),
					'value' => __( 'Send Message', 'directorist-buddypress-integration' ),
				),
				'icon' => array(
					'type'  => 'text',
					'label' => __( 'Icon', 'directorist-buddypress-integration' ),
					'value' => '',
				),
			],
		];
 
		return $fields;
	}

	public static function register_archive_fields( $fields ) {
		if ( ! bp_is_active( 'messages' ) ) {
			return $fields;
		}

		$button_id = 'bp_message_button';
		$button = array(
			'type'    => 'button',
			'id'      => $button_id,
			'label'   => __( 'BuddyPress Message', 'directorist-buddypress-integration' ),
			'icon'    => 'uil uil-envelope',
			'hook'    => 'directorist_bp_message_button',
			'options' => array(
				'title'  => __( 'BP Message Button', 'directorist-buddypress-integration' ),
				'fields' => array(
					'text' => array(
						'type'  => 'text',
						'label' => __( 'Button Text', 'directorist-buddypress-integration' ),
						'value' => __( 'Send Message', 'directorist-buddypress-integration' ),
					),
					'icon' => array(
						'type'  => 'text',
						'label' => __( 'Icon', 'directorist-buddypress-integration' ),
						'value' => '',
					),
				),
			),
		);

		foreach ( $fields as $key => $value ) {
			if ( 'listings_card_grid_view' === $key ) {
				$fields[ $key ]['card_templates']['grid_view_with_thumbnail']['widgets'][ $button_id ] = $button;

				array_push( $fields[ $key ]['card_templates']['grid_view_with_thumbnail']['layout']['footer']['left']['acceptedWidgets'], $button_id );
				array_push( $fields[ $key ]['card_templates']['grid_view_with_thumbnail']['layout']['footer']['right']['acceptedWidgets'], $button_id );
			}
	 
			if ( 'listings_card_list_view' === $key ) {
				$fields[ $key ]['card_templates']['list_view_with_thumbnail']['widgets'][ $button_id ] = $button;

				array_push( $fields[ $key ]['card_templates']['list_view_with_thumbnail']['layout']['footer']['left']['acceptedWidgets'], $button_id );
				array_push( $fields[ $key ]['card_templates']['list_view_with_thumbnail']['layout']['footer']['right']['acceptedWidgets'], $button_id );
			}
		}

		return $fields;
	}
}

Builder::init();
