<?php
/**
 * Actions related functions.
 * 
 */
defined( 'ABSPATH' ) || die();

/**
 * This function is called when a user clicks on the "Share" button on a listing
 * 
 * @return void.
 */
function dbp_share_single_listing_on_timeline() {
	// Return early when activity feed is disabled
	if ( ! bp_is_active( 'activity' ) ) {
		return;
	}

	if ( ! dbp_is_admin_listing_sharing_enabled() || ! bp_is_current_action( 'favorite' ) ) {
		return;
	}

	$action_type = bp_action_variable( 0 );
	$action_value = bp_action_variable( 1 );
	
	if ( empty( $action_type ) || $action_type !== 'share' || empty( $action_value ) ) {
		return;
	}

	$nonce = isset( $_GET['_wpnonce'] ) ? $_GET['_wpnonce'] : '';
	if ( ! wp_verify_nonce( $nonce, 'dbp_single_listing_share_on_timeline' ) ) {
		return;
	}
	
	$listing = get_post( (int) $action_value );
	if ( empty( $listing ) || $listing->post_type !== ATBDP_POST_TYPE || $listing->post_status !== 'publish' ) {
		return;
	}
	
	dbp_listings_record_activity( array(
		'type'    => 'shared_listing',
		'item_id' => $listing->ID,
	) );

	bp_core_redirect( trailingslashit( bp_loggedin_user_domain() . bp_get_activity_slug() ) );
}
add_action( 'bp_actions', 'dbp_share_single_listing_on_timeline' );

/**
 * When a new listing is published, record an activity for it
 * 
 * @param string $new_status The new status of the post.
 * @param string $old_status The status of the post before the transition.
 * @param WP_Post $post The post object.
 * 
 * @return void.
 */
function dbp_transition_post_status_action( $new_status, $old_status, $post ) {
	// Return early when activity feed is disabled
	if ( ! bp_is_active( 'activity' ) ) {
		return;
	}

	if ( $new_status === $old_status || $post->post_type !== ATBDP_POST_TYPE || ! dbp_is_admin_add_listing_sharing_enabled() ) {
		return;
	}

	// Statuses to check the old status
    $old_statuses = array( 'new', 'auto-draft', 'draft', 'private', 'pending', 'future' );

    // Statuses to check the new status
    $new_statuses = array( 'publish' );

    // Check if post status transition come to publish
    if ( ! in_array( $old_status, $old_statuses, true ) || ! in_array( $new_status, $new_statuses, true ) ) {
		return;
	}

	$activity_args = array(
		'type'      => 'new_listing',
		'item_id'   => $post->ID,
		'user_id'   => $post->post_author,
		'component' => buddypress()->listings->id,
	);

	$activity_id = bp_activity_get_activity_id( $activity_args );

	if ( $activity_id ) {
		return;
	}
	
	dbp_listings_record_activity( $activity_args );
}
add_action( 'transition_post_status', 'dbp_transition_post_status_action', 10, 3 );
