;(function($) {
	'use strict';

	$(function() {
		var $listingsDropdown = $('.directorist-listings-dropdown');

		$listingsDropdown.select2({
			width: '100%',
			minimumInputLength: 2,
			ajax: {
				url: DBB.ajaxUrl,
				data: function (params) {
					var query = {
						search: params.term,
						nonce: DBB.nonce,
						action: DBB.action
					}

					return query;
				},
				processResults: function (response) {
					if ( ! response.success ) {
						response.data = [
							{
								id: -1,
								text: 'Not found',
							}
						];
					}

					return {
						results: response.data
					};
				}
			}
		});
	});
}(jQuery));
