<?php
defined('ABSPATH') || die('Direct access is not allowed.');
/**
 * @since 1.1.6
 * @package Directorist
 */
if (!class_exists('PYN_Controller')) :

    class PYN_Controller
    {
        public function __construct()
        {
            add_filter( 'atbdp_listing_type_settings_field_list', array( $this, 'atbdp_listing_type_settings_field_list' ) );

            add_filter( 'directorist_loop_wrapper_class', array( $this, 'directorist_loop_wrapper_class' ), 10, 2 );

            add_action('wp_enqueue_scripts', array($this, 'load_needed_scripts'));


            if( ! get_option('need_directory_type_update') ){
                add_action( 'wp_loaded', array( $this, 'directorist_bulk_update' ) );
            }

        }

        public function directorist_loop_wrapper_class( $class, $listing_type ){
            $term = get_term_by( 'id', $listing_type, ATBDP_TYPE );
            if( 'need-listings' === $term->slug ){
                $new = 'directorist-need-listings';
                array_push( $class, $new );
            }
            return $class;
        }

        public function directorist_bulk_update(){

            if( '7.0' > ATBDP_VERSION ) return;

            $need = '';
            foreach( directory_types() as $type ){
                if( 'need-listings' === $type->slug ){
                    $need = $type->term_id;
                    break;
                }
            }
            $args = array(
                'post_type' => ATBDP_POST_TYPE,
                'posts_per_page' => -1,
                'fields'  => 'ids',
                'meta_key' => '_need_post',
                'meta_value' => 'yes',
                'compare' => '=',
            );
            $atbdp_query = new WP_Query($args);
            if( $atbdp_query->have_posts() ){
                foreach( $atbdp_query->posts as $post_id ){
                    update_post_meta( $post_id, '_directory_type', $need );
                }
                wp_reset_postdata();
            }

            $options = get_option('atbdp_option');

            $options['enable_multi_directory'] = true;

            update_option('atbdp_option', $options);

            update_option( 'need_directory_type_update', 1 );
        }

        public function initial_setup(){
            $directory_types = get_terms( array(
                'taxonomy'   => ATBDP_TYPE,
                'hide_empty' => false,
            ));

            $has_multidirectory = ( ! is_wp_error( $directory_types ) && ! empty( $directory_types ) ) ? true : false;

            $get_listings = new WP_Query([
                'post_type' => ATBDP_POST_TYPE,
                'posts_per_page' => 1,
            ]);

            $get_custom_fields = new WP_Query([
                'post_type' => ATBDP_CUSTOM_FIELD_POST_TYPE,
                'posts_per_page' => 1,
            ]);
            
            $migrated          = get_option( 'atbdp_migrated', false );
            $has_listings      = false;
            $has_custom_fields = false;

            $has_listings        = $get_listings->post_count;
            $has_custom_fields   = $get_custom_fields->post_count;
            $need_migration      = ( empty( $migrated ) && ! $has_multidirectory && ( $has_listings || $has_custom_fields ) ) ? true : false;
            $need_import_default = ( ! $has_multidirectory && ! ( $has_listings || $has_custom_fields ) ) ? true : false;
        }

        public function atbdp_listing_type_settings_field_list( $fields ){
            
            foreach( $fields as $key => $value ) {
            
                if( 'listings_card_grid_view' === $key  ) {
                    // grid with preview image
                     
                      array_push( $fields[$key]['card_templates']['grid_view_with_thumbnail']['layout']['footer']['right']['acceptedWidgets'], 'text' );
                      array_push( $fields[$key]['card_templates']['grid_view_with_thumbnail']['layout']['footer']['right']['acceptedWidgets'], 'date' );
                      
                      // grid without preview image
                      array_push( $fields[$key]['card_templates']['grid_view_without_thumbnail']['layout']['footer']['right']['acceptedWidgets'], 'text' );
                      array_push( $fields[$key]['card_templates']['grid_view_without_thumbnail']['layout']['footer']['right']['acceptedWidgets'], 'date' );
                    }
                    
                    if( 'listings_card_list_view' === $key ) {
                        // grid with preview image
                        array_push( $fields[$key]['card_templates']['list_view_with_thumbnail']['layout']['footer']['right']['acceptedWidgets'], 'text' );
                        array_push( $fields[$key]['card_templates']['list_view_with_thumbnail']['layout']['footer']['right']['acceptedWidgets'], 'date' );
                        
                        // // grid without preview image
                        array_push( $fields[$key]['card_templates']['list_view_without_thumbnail']['layout']['footer']['right']['acceptedWidgets'], 'text' );
                        array_push( $fields[$key]['card_templates']['list_view_without_thumbnail']['layout']['footer']['right']['acceptedWidgets'], 'date' );
                }

            }
            return $fields;
        }

        public function load_needed_scripts()
        {
            if (is_rtl()) {
                wp_enqueue_style('pyn_styles-rtl', PYN_PUBLIC_ASSETS . '/css/main-rtl.css');
            } else {
                wp_enqueue_style('pyn_styles', PYN_PUBLIC_ASSETS . '/css/main.css');
            }
        }

    }
endif;