<?php
/**
 * Template Loader
 *
 * @since 1.0
 */
function swbdp_2chkt_load_template( string $template_path = '', $data = array(), string $return_type = 'echo' ) {
	$path = SWBDP_2CHKT_PLUGIN_PATH . "templates/$template_path.php";

	ob_start();

	if ( file_exists( $path ) ) {
		include $path;
	}

	$content = ob_get_clean();

	if ( 'echo' !== $return_type ) {
		return $content;
	}

	echo $content;
};



/**
 * It returns the link to the custom search archive page of ATBDP
 * @param array $query_vars [optional] Array of query vars to be added to the registration page url
 * @return string
 */
function get_auth_confirmation_page_link($query_vars=array())
{

    $link = home_url();
    $id = get_directorist_option( 'authorize_gateway' ); // get the page id of the custom registration page.
    if( $id ) $link = get_permalink( $id );
    if (!empty($query_vars) && is_array($query_vars)){
        $link = add_query_arg( $query_vars, $link );
    }
    return apply_filters('atbdp_auth_confirmmstion_page_url', $link);
}


function get_pages_vl_arrays()
{
    $pages = get_pages();
    $pages_options = array();
    if ($pages) {
        foreach ($pages as $page) {
            $pages_options[] = array('value' => $page->ID, 'label' => $page->post_title);
        }
    }

    return $pages_options;
}

if ( ! function_exists( 'directorist_is_plugin_active' ) ) {
    function directorist_is_plugin_active( $plugin ) {
        return in_array( $plugin, (array) get_option( 'active_plugins', array() ), true ) || directorist_is_plugin_active_for_network( $plugin );
    }
}

if ( ! function_exists( 'directorist_is_plugin_active_for_network' ) ) {
    function directorist_is_plugin_active_for_network( $plugin ) {
        if ( ! is_multisite() ) {
            return false;
        }
                
        $plugins = get_site_option( 'active_sitewide_plugins' );
        if ( isset( $plugins[ $plugin ] ) ) {
                return true;
        }

        return false;
    }
}