<?php
/**
 * Directorist - Authorize.net
 *
 * @package           Directorist_Authorize_Net
 * @author            wpwax
 * @copyright         2019 wpwax or Company Name
 * @license           GPL-2.0-or-later
 *
 * @wordpress-plugin
 * Plugin Name:       Directorist - Authorize.net
 * Plugin URI:        https://directorist.com/product/directorist-authorize-net/
 * Description:       A checkout extension for directorist
 * Version:           1.0.2
 * Requires at least: 5.2
 * Requires PHP:      7.2
 * Author:            wpwax
 * Author URI:        https://wpwax.com/
 * Text Domain:       directorist-authorize-net
 * License:           GPL v2 or later
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 */


defined( 'ABSPATH' ) || exit;

// Setup The Consts.
if ( ! defined( 'SWBDP_2CHKT_PLUGIN_FILE' ) ) {
	define( 'SWBDP_2CHKT_PLUGIN_FILE', __FILE__ );
}

// Include The Const Helpers.
$const_helper_file = plugin_dir_path( __FILE__ ) . '/helpers/const-helper.php';
require $const_helper_file;

$const_file = plugin_dir_path( __FILE__ ) . '/const.php';
require $const_file;

// Include The Helpers.
$helpers_file = SWBDP_2CHKT_PLUGIN_PATH . 'helpers/helpers.php';
require $helpers_file;

// Include The App.
$app = SWBDP_2CHKT_PLUGIN_PATH . 'app/base.php';

if (  directorist_is_plugin_active( 'directorist/directorist-base.php' ) && ! class_exists( 'Directorist_2Checkout' ) ) {
	include $app;
}
