; (function( $ ) {

    $('#test-checkout-form').card({
        container: '.card-wrapper',
        messages: {
            monthYear: 'mm-yyyy', // optional - default 'month/year'
        },
    });

    // @todo remove once the gateway is compatible with pricing plans recurring concept
    var recurring = $('#recurring').val();
    if( recurring ) {
        $("#authorize_gateway").attr('disabled',true);
    }

    const query_string = (function(a) {
        if (a == '') return {};
        const b = {};
        for (let i = 0; i < a.length; ++i) {
                const p = a[i].split('=', 2);
                if (p.length == 1) b[p[0]] = '';
                else b[p[0]] = decodeURIComponent(p[1].replace(/\+/g, ' '));
        }
        return b;
    })(window.location.search.substr(1).split('&'));

    function setupFormData( form, form_data ) {
        var arrData = form.serializeArray();
        $.each(arrData, function (index, elem) {
            var value = elem.value;
            if( elem.name === 'expiry' ){
                var value = value.replace( '/', '-' ).replace( /\s/g, '' );
            }
            form_data.append( elem.name, value );
        });
        
    };

    $('#test-checkout-form').on( 'submit', function( e ) {
        e.preventDefault(); 
        const form_data = new FormData();
        // ajax action
        form_data.append('action', 'authorize_gateway_process_payment');
        form_data.append('order_id', query_string.order_id);
        var form = $(this);
        setupFormData( form, form_data );
        
        $.ajax({
            method: 'POST',
            processData: false,
            contentType: false,
            url: localized_data.ajax_url,
            data: form_data,
            success(response) {
                // console.log(response);
                // return;
                if( response[ 'success' ] ) {
                    // console.log(response);
                    $( '.payment_notifier' ).empty().append( `<span class="atbdp_auth_alert atbdp_auth_alert-success  payment_success">`+ response['message'] +`</span>` );
                    window.location.href = response['redirect_url'];
                }else {
                    // console.log(response);
                    $( '.payment_notifier' ).empty().append( `<span class="atbdp_auth_alert atbdp_auth_alert-error  payment_failed">`+ response['message'] +`</span>` );
                    window.location.href = response['redirect_url'];
                }
            }

        });
    });
})( jQuery );