<?php
defined( 'ABSPATH' ) || exit;

use SWBDP_2CHKT\Setup\APP_Settings;
use SWBDP_2CHKT\Setup\Enqueue;
use SWBDP_2CHKT\API\TwoCheckoutAPI;
use SWBDP_2CHKT\Hooks\Hooks;
use SWBDP_2CHKT\Shortcodes\Shortcodes;

final class Directorist_2Checkout {

	/**
	 * Instance
	 *
	 * @return Directorist_2Checkout
	 * @since 1.0
	 */
	private static $instance;

	/**
	 * Get The Instance
	 *
	 * @return Directorist_2Checkout
	 */
	public static function instance() {
		if ( is_null( self::$instance ) ) {
			self::$instance = new self();

			// enable translation.
			add_action( 'plugins_loaded', array( self::$instance, 'load_textdomain' ) );
		}

		return self::$instance;
	}

	/**
	 * It loads plugin text domain
	 *
	 * @since 1.0.0
	 */
	public function load_textdomain() {
		load_plugin_textdomain( 'directorist-authorize.net', false, SWBDP_2CHKT_LANG_PATH );
	}

	/**
	 * Constructor
	 *
	 * @return void
	 */
	public function __construct() {
		$this->includes();
		$this->register_services();
	}

	/**
	 * File Includer
	 *
	 * @return void
	 */
	public function includes() {
		$files = array(
			'app/Setup/APP_Settings',
			'app/Setup/Enqueue',
			'app/Lib/2Checkout/autoload',
			'app/API/TwoCheckoutAPI',
			'app/Hooks/Hooks',
			'app/Shortcodes/Shortcodes',
			'app/Shortcodes/Authorize_Gateway_Checkout',
		);

		foreach ( $files as $file ) {
			$file_path = SWBDP_2CHKT_PLUGIN_PATH . "{$file}.php";
			if ( ! file_exists( $file_path ) ) {
				continue;
			}
			include $file_path;
		}
	}

	/**
	 * Get Services
	 *
	 * @return array
	 */
	public function get_services() {
		return array(
			APP_Settings::class,
			Enqueue::class,
			TwoCheckoutAPI::class,
			Shortcodes::class,
			Hooks::class,
		);
	}

	/**
	 * Register Services
	 *
	 * @return void
	 */
	public function register_services() {
		$services = $this->get_services();

		if ( ! count( $services ) ) {
			return;
		}
		foreach ( $services as $class_name ) {
			if ( class_exists( $class_name ) ) {
				if ( method_exists( $class_name, 'register' ) ) {
					$service = new $class_name();
					$service->register();
				}
			}
		}
	}
}

function Directorist_2Checkout() {
	return Directorist_2Checkout::instance();
}

Directorist_2Checkout();
