<?php
namespace SWBDP_2CHKT\Shortcodes;

class Shortcodes {
	/**
	 * Register
	 *
	 * @return void
	 */
	public function register() {
		$this->register_shortcodes();
	}

	/**
	 * Get Shortcodes
	 *
	 * @return array
	 */
	public function get_shortcodes() {
		return array(
			'directorist_authorize_gateway' => Authorize_Gateway_Checkout::class,
		);
	}

	/**
	 * Register Shortcodes
	 *
	 * @return void
	 */
	public function register_shortcodes() {
		$shortcodes = $this->get_shortcodes();

		if ( ! count( $shortcodes ) ) {
			return;}

		foreach ( $shortcodes as $shortcode_name => $class_name ) {
			if ( class_exists( $class_name ) ) {
				if ( method_exists( $class_name, 'render' ) ) {
					$shortcode = new $class_name();
					add_shortcode( $shortcode_name, array( $shortcode, 'render' ) );
				}
			}
		}
	}
}
