<?php
namespace SWBDP_2CHKT\Setup;

class Enqueue {
	/**
	 * Register
	 *
	 * @return void
	 */
	public function register() {
		add_action( 'wp_enqueue_scripts', array( $this, 'load_frontend_scripts' ) );
	}

	/**
	 * Get Frontend Styles
	 * array params id, src, dep, ver, media
	 *
	 * @return array
	 */
	public function get_frontend_styles() {
		$styles = array(
			'bootstrap'              => array(
				'src'     => '//maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css',
				'ver'     => '4.0',
				'desable' => true,
			),
			'swbdp_2chkt_card_style' => array(
				'src' => SWBDP_2CHKT_CSS_URI . 'card.css',
			),
			'swbdp_2chkt_main_style' => array(
				'src' => SWBDP_2CHKT_CSS_URI . 'main.css',
			),
		);

		return apply_filters( 'swbdp_2chkt_frontend_styles', $styles );
	}

	/**
	 * Get Frontend Scripts
	 * array params id, src, dep, ver, in_footer
	 *
	 * @return array
	 */
	public function get_frontend_scripts() {
		$scripts = array(
			'popper'                  => array(
				'src'     => '//cdn.jsdelivr.net/npm/popper.js@1.16.0/dist/umd/popper.min.js',
				'desable' => true,
			),
			'bootstrap'               => array(
				'src'     => '//maxcdn.bootstrapcdn.com/bootstrap/4.0.0/js/bootstrap.min.js',
				'dep'     => array( 'jquery', 'popper' ),
				'ver'     => '4.0',
				'desable' => true,
			),
			'swbdp_2chkt_card_script' => array(
				'src' => SWBDP_2CHKT_JS_URI . 'card.js',
				'dep' => array( 'jquery' ),
			),
			'swbdp_2chkt_main_script' => array(
				'src' => SWBDP_2CHKT_JS_URI . 'main.js',
				'dep' => array( 'jquery' ),
			),
		);

		return apply_filters( 'swbdp_2chkt_frontend_scripts', $scripts );
	}

	/**
	 * Register Styles
	 *
	 * @return void
	 */
	public function register_styles( array $styles ) {
		foreach ( $styles as $id => $args ) {

			if ( ! empty( $args['desable'] ) ) {
				continue;
			}

			$defaults = array(
				'src'   => '',
				'dep'   => array(),
				'ver'   => false,
				'media' => 'all',
			);

			$args = array_merge( $defaults, $args );
			wp_register_style( $id, $args['src'], $args['dep'], $args['ver'], $args['media'] );
		}
	}

	/**
	 * Register Scripts
	 *
	 * @return void
	 */
	public function register_scripts( array $scripts ) {
		foreach ( $scripts as $id => $args ) {

			if ( ! empty( $args['desable'] ) ) {
				continue;
			}

			$defaults = array(
				'src'       => '',
				'dep'       => array(),
				'ver'       => false,
				'in_footer' => true,
			);

			$args = array_merge( $defaults, $args );
			wp_register_script( $id, $args['src'], $args['dep'], $args['ver'], $args['in_footer'] );
		}
	}

	/**
	 * Enqueue Styles
	 *
	 * @return void
	 */
	public function enqueue_styles( array $styles ) {
		foreach ( $styles as $id => $args ) {
			wp_enqueue_style( $id );
		}
	}

	/**
	 * Enqueue Scripts
	 *
	 * @return void
	 */
	public function enqueue_scripts( array $scripts ) {
		foreach ( $scripts as $id => $args ) {
			wp_enqueue_script( $id );
		}
	}

	/**
	 * Upgrade JQuery
	 *
	 * @return void
	 */
	public function upgrade_jquery() {
		wp_dequeue_script( 'jquery' );
		wp_deregister_script( 'jquery' );

		wp_register_script( 'jquery', '//code.jquery.com/jquery-3.5.1.min.js', false, '3.5.1', 'true' );
		wp_enqueue_script( 'jquery' );
	}

	/**
	 * Load Frontend Scripts
	 *
	 * @return void
	 */
	public function load_frontend_scripts() {
		// Load Frontend Styles
		$frontend_styles = $this->get_frontend_styles();
		$this->register_styles( $frontend_styles );
		$this->enqueue_styles( $frontend_styles );

		// Upgrade JQuery
		$upgrade_jquery = apply_filters( 'swbdp_2chkt_upgrade_jquery', false );
		if ( $upgrade_jquery ) {
			$this->upgrade_jquery();
		}

		// Load Frontend Scripts
		$frontend_scripts = $this->get_frontend_scripts();
		$this->register_scripts( $frontend_scripts );
		$this->enqueue_scripts( $frontend_scripts );
		$data = [
			'ajax_url' => admin_url( 'admin-ajax.php' ),
		];
		wp_localize_script( 'swbdp_2chkt_main_script', 'localized_data', $data );
	}
}
