<?php
namespace SWBDP_2CHKT\Setup;

use ATBDP_Permalink;
use DateTime;
use DateInterval;
use net\authorize\api\contract\v1 as AnetAPI;
use net\authorize\api\controller as AnetController;

class APP_Settings {

	public function register() {
		// die();
	}

	public function __construct() {
		// Add authorize.net gateway to the active gateway & default gateways selections.
		add_filter( 'directorist_active_gateways', array( $this, 'default_active_gateways' ) );
		add_filter( 'atbdp_default_gateways', array( $this, 'default_active_gateways' ) );
		add_filter( 'atbdp_monetization_settings_submenu', array( $this, 'authorize_gateway_settings_submenu' ));
		add_filter( 'atbdp_listing_type_settings_field_list', array( $this, 'atbdp_listing_type_settings_field_list' ) );
		if (get_option('atbdp_authorize_gateway_page_create') < 1) {
			add_action('wp_loaded', array($this, 'add_custom_page'));
		}

		add_filter('atbdp_pages_settings_fields', array($this, 'atbdp_pages_settings_fields'));
		add_action('atbdp_process_authorize_gateway_payment', array($this, 'process_payment'), 30, 1);
		add_action('wp_ajax_authorize_gateway_process_payment', array($this, 'authorize_gateway_process_payment') );

	}

	public function add_custom_page()
	{
		$create_permission = apply_filters('atbdp_create_required_pages', true);
		if ($create_permission) {
			$this->create_required_pages();
		}
	}

	public function authorize_gateway_process_payment() {

		$cvc = !empty($_POST['cvc']) ? sanitize_key($_POST['cvc']) : '';
		$expiry = !empty($_POST['expiry']) ? sanitize_key($_POST['expiry']) : '';
		$card_number = !empty($_POST['number']) ? sanitize_key($_POST['number']) : '';
		$order_id = !empty($_POST['order_id']) ? sanitize_key($_POST['order_id']) : '';
		$name = !empty($_POST['name']) ? $_POST['name'] : '';
		$zip = !empty($_POST['zip']) ? sanitize_key($_POST['zip']) : '';
		$country = !empty($_POST['country']) ? $_POST['country'] : '';
		$amount = get_post_meta($order_id, '_amount', true);


		$args = [
			'card' => $card_number,
			'expire' => $expiry,
			'cvc' => $cvc,
			'order_id' => $order_id,
			'product' => '',
			'name' => $name,
			'zip' => $zip,
			'country' => $country,
			'amount' => $amount,
		];
		// wp_send_json($args);

		// $payment_response = $this->accept_payment( '4111111111111111', '2038-12', '52' );
		$payment_response = $this->capture_the_payment_and_prepare_data( $args );
		//wp_send_json($payment_response);

		if( $payment_response['success'] ) {
			$hash = wp_generate_password(12, false);
			$this->complete_order(
                [ 'ID' => $order_id, 'transaction_id' => $hash ]
            );
			$payment_response['redirect_url'] = ATBDP_Permalink::get_payment_receipt_page_link( $order_id );
		}else{
			$payment_response['redirect_url'] = ATBDP_Permalink::get_transaction_failure_page_link();
		}
		wp_send_json( $payment_response );
	}


	public function capture_the_payment_and_prepare_data( $args ) {
		define( 'AUTHORIZENET_LOG_FILE', 'phplog' );

		$default = [
			'card' => '',
			'expire' => '',
			'cvc' => '',
			'order_id' => '',
			'product' => '',
			'name' => '',
			'zip' => '',
			'country' => '',
			'amount' => '',
		];

		$args = array_merge( $default, $args );
		$data = [];
		$data['success'] = true;
		$authorize_login_id = get_directorist_option( 'authorize_login_id' );
		$authorize_transaction_key = get_directorist_option( 'authorize_transaction_key' );
		$sandbox = get_directorist_option('gateway_test_mode', true);
		// Common setup for API credentials
		$merchantAuthentication = new AnetAPI\MerchantAuthenticationType();
		$merchantAuthentication->setName( $authorize_login_id );
		$merchantAuthentication->setTransactionKey( $authorize_transaction_key );
		$refId = 'ref' . time();

		 // Set the customer's Bill To address
		 $customerAddress = new AnetAPI\CustomerAddressType();
		 $customerAddress->setFirstName($args['name']);
		 $customerAddress->setZip( $args['zip'] );
		 $customerAddress->setCountry( $args['country'] );

		// Create the payment data for a credit card
		$creditCard = new AnetAPI\CreditCardType();
		$creditCard->setCardNumber( $args['card'] );
		$creditCard->setExpirationDate( $args['expire'] );
		$paymentOne = new AnetAPI\PaymentType();
		$paymentOne->setCreditCard( $creditCard );

		// Create a transaction
		$transactionRequestType = new AnetAPI\TransactionRequestType();
		$transactionRequestType->setTransactionType( 'authCaptureTransaction' );
		$transactionRequestType->setAmount( $args['amount'] );
		$transactionRequestType->setPayment( $paymentOne );
		$transactionRequestType->setBillTo( $customerAddress );

		$request = new AnetAPI\CreateTransactionRequest();
		$request->setMerchantAuthentication( $merchantAuthentication );
		$request->setRefId( $refId );
		$request->setTransactionRequest( $transactionRequestType );
		$controller = new AnetController\CreateTransactionController( $request );
		if( $sandbox ) {
			$response   = $controller->executeWithApiResponse( \net\authorize\api\constants\ANetEnvironment::SANDBOX );
		}else {
			$response   = $controller->executeWithApiResponse( \net\authorize\api\constants\ANetEnvironment::PRODUCTION );
		}
		// wp_send_json([
		// 	'controller' => $controller,
		// 	'response'   => $response,
		// 	'request'	 => $request,
		// ]);

		if ( $response != null ) {
			$tresponse = $response->getTransactionResponse();
			if ( ( $tresponse !== null ) && ( $tresponse->getResponseCode() === '1' ) ) {
				$data['transaction_data'] 	= $tresponse;
				$msg 						= $tresponse->getMessages();
				$data['message'] 			= $msg[0]->getDescription();
			} else {
				$data['success'] = false;
				$data['message'] = "Charge Credit Card ERROR :  Invalid response";
			}
		} else {
			$data['success'] = false;
			$data['message'] = 'Charge Credit Card Null response returned';
		}
		return $data;
	}

	     /**
         * It process the payment of the given order
         * @param int $order_id
         * @since 1.0.0
         */
        public function process_payment( $order_id )
        {

			$gateway             = get_post_meta($order_id, '_payment_gateway', true);
			$url = get_auth_confirmation_page_link( [ 'order_id' => $order_id ] );

			if( 'authorize_gateway' === $gateway ) {
				wp_safe_redirect( $url );
				exit;
			}

		}

		       /**
         * It completes order
         * @param $order_data
         * @since 1.0.0
         * @todo; think if it is better to move this to Order Class later
         */
        private function complete_order( $order_data )
        {
            // add payment status, tnx_id etc.
            update_post_meta($order_data['ID'], '_payment_status', 'completed');
			update_post_meta($order_data['ID'], '_transaction_id', $order_data['transaction_id']);


            // If the order has featured, make the related listing featured.
            $featured = get_post_meta($order_data['ID'], '_featured', true);
            // use given listing id or fetch the ID
            $listing_id = get_post_meta($order_data['ID'], '_listing_id', true);
            $new_l_status = get_directorist_option('new_listing_status', 'pending');

            if (!empty($featured)) {
                update_post_meta($listing_id, '_featured', 1);
            }
            if (get_post_status($listing_id) != 'publish') {
                $plan_id = get_post_meta($listing_id, '_fm_plans', true);
                $package_length = get_post_meta($plan_id, 'fm_length', true);
                $fm_length_unl = get_post_meta($plan_id, 'fm_length_unl', true);
                $package_length = $package_length ? $package_length : '1';
                // Current time
                $current_d = current_time('mysql');
				// Calculate new date
                $date = new DateTime($current_d);
                $date->add(new DateInterval("P{$package_length}D")); // set the interval in days
                $expired_date = $date->format('Y-m-d H:i:s');
                // is it renewal order? yes, lets update the listing according to plan
				$is_renewal = get_post_meta($listing_id, '_renew_with_plan', true);

                if (!empty($is_renewal)) {
                    $time = current_time('mysql');
                    $post_array = array(
                        'ID' => $listing_id,
                        'post_status' => 'publish',
                        'post_date' => $time,
                        'post_date_gmt' => get_gmt_from_date($time)
                    );
                    //Updating listing
                    wp_update_post($post_array);

                    // Update the post_meta into the database && update related post metas
                    if (!empty($fm_length_unl)) {
                        update_post_meta($listing_id, '_never_expire', 1);
                    } else {

                        update_post_meta($listing_id, '_expiry_date', $expired_date);
                    }
                    update_post_meta($listing_id, '_listing_status', 'post_status');
                } else {
                    $my_post = array();
                    $my_post['ID'] = $listing_id;
                    $my_post['post_status'] = $new_l_status;
                    wp_update_post($my_post);
                }

            }
            // Order has been completed. Let's fire a hook for a developer to extend if they wish
            do_action('atbdp_order_completed', $order_data['ID'], $listing_id);
        }


	/**
	 * It adds our gateways to the active and default gateways list.
	 *
	 * @param array $gateways Arrays of all old gateways.
	 * @return array It returns the new gateways list after adding authorize gateways.
	 * @since 1.0.0
	 */
	public function default_active_gateways( $gateways ) {
		$gateways[] = array(
			'value' => 'authorize_gateway',
			'label' => __( 'Authorize.net', 'directorist-authorize.net' ),
		);
		return $gateways;
	}

	public function create_required_pages()
	{
		$options = get_option('atbdp_option');
		$page_exists = get_option('atbdp_authorize_gateway_page_create');
		// $op_name is the page option name in the database.
		// if we do not have the page id assigned in the settings with the given page option name, then create an page
		// and update the option.
		$id = array();
		if (!$page_exists) {
			$id = wp_insert_post(
				array(
					'post_title' => 'Confirm Payment Details',
					'post_content' => '[directorist_authorize_gateway]',
					'post_status' => 'publish',
					'post_type' => 'page',
					'comment_status' => 'closed'
				)
			);
		}
		// if we have new options then lets update the options with new option values.
		if ($id) {
			update_option('atbdp_authorize_gateway_page_create', 1);
			$options['authorize_gateway'] = (int) $id;
			update_option('atbdp_option', $options);
		};
	}

	public function atbdp_pages_settings_fields($fields)
	{
		$fields[] = ['authorize_gateway'];
        return $fields;
	}

	/**
	 * It adds a submenu of authorize gateway settings
	 *
	 * @param array $submenus
	 * @return array
	 * @since 1.0.0
	 */
	public function authorize_gateway_settings_submenu( $submenus ) {
		$submenus['authorize_gateway_submenu'] = array(
			'label'    => __( 'Authorize.net Gateway', 'directorist-authorize.net' ),
			'icon'     => '<i class="fab fa-cc-stripe"></i>',
			'sections' => apply_filters( 'atbdp_authorize_gateway_settings_controls', array(
					'gateways' => array(
						'title'       => __( 'Authorize.net Gateway Settings', 'directorist-authorize.net' ),
						'description' => __( 'You can customize all the settings related to your authorize gateway. After switching any option, Do not forget to save the changes.', 'directorist-authorize.net' ),
						'fields'      => [ 'authorize_gateway_note', 'authorize_gateway_title', 'authorize_gateway_description', 'authorize_login_id', 'authorize_transaction_key' ],
					),
				)
			),
		);
		return $submenus;
	}


	public function atbdp_listing_type_settings_field_list( $fields ) {

		$gsp           = sprintf( "<a target='_blank' href='%s'>%s</a>", esc_url( admin_url( 'edit.php?post_type=at_biz_dir&page=aazztech_settings#_gateway_general' ) ), __( 'Gateway Settings Page', 'directorist-authorize.net' ) );
		$authorize_url = sprintf( "<a target='_blank' href='%s'>%s</a>", esc_url( 'https://sandbox.authorize.net/' ), __( 'Get your API Login ID and Transaction Key', 'directorist-authorize.net' ) );

		$fields['authorize_gateway_note'] = [
			'type'               => 'note',
			'label'       => __( 'Note About Authorize Gateway:', 'directorist-authorize.net' ),
			'description' => sprintf( __( 'If you want to use Authorize for a testing purpose, you should set Test MODE to Yes on The %s.', 'directorist-authorize.net' ), $gsp ),
		];
		$fields['authorize_gateway_title'] = [
			'type'        => 'text',
			'label'       => __( 'Gateway Title', 'directorist-authorize.net' ),
			'description' => __( 'Enter the title of this gateway that should be displayed to the user on the front end.', 'directorist-authorize.net' ),
			'value'     => esc_html__( 'Authorize', 'directorist-authorize.net' ),
		];
		$fields['authorize_gateway_description'] = [
			'type'        => 'text',
			'label'       => __( 'Gateway Description', 'directorist-authorize.net' ),
			'description' => __( 'Enter some description for your user to make payment using authorize.', 'directorist-authorize.net' ),
			'value'       => __( 'You can make payment using your credit card using authorize if you choose this payment gateway.', 'directorist-authorize.net' ),
		];

		$fields['authorize_login_id'] = [
			'type'        => 'text',
			'label'       => __( 'API Login ID', 'directorist-authorize.net' ),
			'description' => sprintf( __( 'Enter your Authorize Live Publishable Key Here. You can find your API key on your Authorize Dashboard Under Developers > API section. %s', 'directorist-authorize.net' ), $authorize_url ),
			'value'       => '',
		];

		$fields['authorize_transaction_key'] = [
			'type'        => 'text',
			'label'       => __( 'Transaction Key', 'directorist-authorize.net' ),
			'description' => sprintf( __( 'Enter your Authorize Live Secret Key Here. You can find your API key on your Authorize Dashboard Under Developers > API section. %s', 'directorist-authorize.net' ), $authorize_url ),
			'value'       => '',
		];

		$fields['authorize_gateway'] = [
            'label'             => __('Authorize Gateway Page', 'directorist-booking'),
            'type'              => 'select',
			'description' 		=> sprintf(__('Following shortcode must be in the selected page %s', 'directorist-authorize.net'), '<strong style="color: #ff4500;">[directorist_authorize_gateway]</strong>'),
            'value'             => atbdp_get_option('authorize_gateway', 'atbdp_general'),
            'showDefaultOption' => true,
            'options'           => get_pages_vl_arrays(),
        ];

		return $fields;
	}


	/**
	 * It register the settings fields of authorize gateway
	 *
	 * @return array It returns an array of authorize settings fields array
	 * @since 1.0.0
	 */
	public function get_authorize_gateway_settings_fields() {
		$gsp           = sprintf( "<a target='_blank' href='%s'>%s</a>", esc_url( admin_url( 'edit.php?post_type=at_biz_dir&page=aazztech_settings#_gateway_general' ) ), __( 'Gateway Settings Page', 'directorist-authorize.net' ) );
		$authorize_url = sprintf( "<a target='_blank' href='%s'>%s</a>", esc_url( 'https://sandbox.authorize.net/' ), __( 'Get your API Login ID and Transaction Key', 'directorist-authorize.net' ) );

		return apply_filters(
			'atbdp_authorize_gateway_settings_fields',
			array(
				array(
					'type'        => 'notebox',
					'name'        => 'authorize_gateway_note',
					'label'       => __( 'Note About Authorize Gateway:', 'directorist-authorize.net' ),
					'description' => sprintf( __( 'If you want to use Authorize for a testing purpose, you should set Test MODE to Yes on The %s.', 'directorist-authorize.net' ), $gsp ),
					'status'      => 'info',
				),
				array(
					'type'        => 'textbox',
					'name'        => 'authorize_gateway_title',
					'label'       => __( 'Gateway Title', 'directorist-authorize.net' ),
					'description' => __( 'Enter the title of this gateway that should be displayed to the user on the front end.', 'directorist-authorize.net' ),
					'default'     => esc_html__( 'Authorize', 'directorist-authorize.net' ),
				),
				array(
					'type'        => 'textarea',
					'name'        => 'authorize_gateway_description',
					'label'       => __( 'Gateway Description', 'directorist-authorize.net' ),
					'description' => __( 'Enter some description for your user to make payment using authorize.', 'directorist-authorize.net' ),
					'default'     => __( 'You can make payment using your credit card using authorize if you choose this payment gateway.', 'directorist-authorize.net' ),
				),
				array(
					'type'        => 'textbox',
					'name'        => 'authorize_login_id',
					'label'       => __( 'API Login ID', 'directorist-authorize.net' ),
					'description' => sprintf( __( 'Enter your Authorize Live Publishable Key Here. You can find your API key on your Authorize Dashboard Under Developers > API section. %s', 'directorist-authorize.net' ), $authorize_url ),
					'default'     => '',
				),
				array(
					'type'        => 'textbox',
					'name'        => 'authorize_transaction_key',
					'label'       => __( 'Transaction Key', 'directorist-authorize.net' ),
					'description' => sprintf( __( 'Enter your Authorize Live Secret Key Here. You can find your API key on your Authorize Dashboard Under Developers > API section. %s', 'directorist-authorize.net' ), $authorize_url ),
					'default'     => '',
				),
			)
		);
	}

}
