<?php
/** 
 * @package  Directorist - Coupon
 */

/**
 * Plugin Name:       Directorist - Coupon
 * Plugin URI:        https://wpwax.com
 * Description:       Create & offer unlimited coupon to increase your revenue.
 * Version:           1.1.3
 * Requires at least: 5.2
 * Author:            wpWax
 * Author URI:        https://wpwax.com
 * License:           GPL v2 or later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       directorist-coupon
 * Domain Path:       /languages
 */

/* This is an extension for Directorist plugin. It helps to you to display ads on your site. It can be perfectly prcess and
manage the ads which you want to show on your web site.*/

/**
 * If this file is called directly, abrot!!!
 */ 
if( ! defined( 'ABSPATH' ) ) {
    exit;                      // Exit if accessed
}



if( ! class_exists( 'SWBDPCoupon' ) ){
    /**
     * Plugin's main class
     */
    final class SWBDPCoupon
    {   
        /**
        * Created plugin Singleton instance
        *
        * @var string
        */
        private static $instance;    


        /**
         * Class constructor
         * 
         * @return object SWBDPCoupon 
         */
        public static function instance()
        {
            // Authenticate, is instance created or not
            if( ! isset( self::$instance ) && !( self::$instance instanceof SWBDPCoupon ) ){
                self::$instance = new SWBDPCoupon();
                self::$instance->define_constant();
                self::$instance->instance_plugin_classes();
            }

            return self::$instance;
        }

        public static function get_version_from_file_content( $file_path = '' ) {
            $version = '';
    
            if ( ! file_exists( $file_path ) ) {
                return $version;
            }
    
            $content = file_get_contents( $file_path );
            $version = self::get_version_from_content( $content );
            
            return $version;
        }

        public static function get_version_from_content( $content = '' ) {
            $version = '';
    
            if ( preg_match('/\*[\s\t]+?version:[\s\t]+?([0-9.]+)/i', $content, $v) ) {
                $version = $v[1];
            }
    
            return $version;
        }
        
        /**
        * Define the required plugin constant
        *
        * @return void
        */
        public function define_constant()
        {
            $version = self::get_version_from_file_content( __FILE__ );
            define( 'SWBDPC_PLUGIN_VERSION', $version );
            define( 'SWBDPC_POST_TYPE', 'swbdp-coupon' );
            define( 'SWBDPC_BASE_FILE', __FILE__ );
            define( 'SWBDPC_PLUGIN_DIR_PATH', dirname( __FILE__ ) ."/" );
            define( 'SWBDPC_PLUGIN_DIR_URL', plugin_dir_url( __FILE__ ) );
            define( 'SWBDPC_PLUGIN_DIRNAME', dirname( plugin_basename( __FILE__ ) ) );            
            define( 'SWBDPC_PLUGIN_TEMPLATES_DIR', dirname( __FILE__ ) ."/Inc/View/" );            
            define( 'SWBDPC_ADMIN_CSS', SWBDPC_PLUGIN_DIR_URL ."assets/admin/css/" );
            define( 'SWBDPC_ADMIN_JS', SWBDPC_PLUGIN_DIR_URL ."assets/admin/js/" );
            define( 'SWBDPC_FRONTEND_CSS', SWBDPC_PLUGIN_DIR_URL ."assets/frontend/css/" );
            define( 'SWBDPC_FRONTEND_JS', SWBDPC_PLUGIN_DIR_URL ."assets/frontend/js/" );
            // plugin author url
            if (!defined('ATBDP_AUTHOR_URL')) { define('ATBDP_AUTHOR_URL', 'https://directorist.com');}
            // post id from download post type (edd)
            if (!defined('ATBDP_COUPON_POST_ID')) { define('ATBDP_COUPON_POST_ID', 32345);}
        }
        


        /**
         * Iintialize all other classes of this plugin
         *
         * @return void
         */
        public function instance_plugin_classes()
        {

            if (!class_exists('EDD_SL_Plugin_Updater')) {
                // load our custom updater if it doesn't already exist
                include(dirname(__FILE__) . '/Inc/Controller/Admin/EDD_SL_Plugin_Updater.php');
            }
            // setup the updater
            $license_key = trim(get_option('directorist_coupon_license'));
            new EDD_SL_Plugin_Updater(ATBDP_AUTHOR_URL, __FILE__, array(
                'version'   => SWBDPC_PLUGIN_VERSION,        // current version number
                'license'   => $license_key,    // license key (used get_option above to retrieve from DB)
                'item_id'   => ATBDP_COUPON_POST_ID,    // id of this plugin
                'author'    => 'AazzTech',    // author of this plugin
                'url'       => home_url(),
                'beta'      => false // set to true if you wish customers to receive update notifications of beta releases
            ));


            if( file_exists( SWBDPC_PLUGIN_DIR_PATH . 'includes.php' ) ){
                // Require all class's files
                require_once( SWBDPC_PLUGIN_DIR_PATH . 'includes.php' );
                SWBDPCIncludeClasses::includes();
            
                $classes_name = array(
                    'SWBDPCEnqueue',
                    'SWBDPCActivate',
                    'SWBDPCouponCPT',
                    'SWBDPCAjaxHandler',
                    'SWBDPCouponHandler',
                    'SWBDPCDynamicStyle',
                    'SWBDPCHelperFunctions',
                    'SWBDPCShortcodeHandler',
                    'SWBDPCExtensionSettings',
                    'SWBDPCCustomWpListTable',
                );

                foreach( $classes_name as $class_name ){
                    if( method_exists( $class_name, 'register' ) ){
                        $object = new $class_name;
                        $object->register();
                    }                
                }
            }    
        }

    }// End class


    /**
     * Initializes the main plugin
     *
     * @return \SWBDPCoupon class
     */
    function SWBDPCoupon()
    {
        return SWBDPCoupon::instance();        
    }


    /**
     * Handle plugin activation
     *
     * @return void
     */
    function swbdp_coupon_plugin_activate()
    {
        // Get the Directorist plugin is active or deactive
        if( in_array( 'directorist/directorist-base.php', ( array )get_option( 'active_plugins' ) ) ) {

            // Get Directorist - Coupon plugin activation time
            $installed = get_option( 'swbdp_coupon_installed' );
            if( ! $installed ){
                update_option( 'swbdp_coupon_installed', time() );
            }
            // Store current version of this plugin.
            update_option( 'swbdp_coupon_version', SWBDPC_PLUGIN_VERSION );            
        }

    }
    register_activation_hook( __FILE__, 'swbdp_coupon_plugin_activate' );



    /**
    * Handle plugin deactivation
    *
    * @return void
    */
    function swbdp_coupon_plugin_deactivate()
    {
        //flush_rewrite_rules();
    }
    register_deactivation_hook( __FILE__, 'swbdp_coupon_plugin_deactivate' );

    if ( ! function_exists( 'directorist_is_plugin_active' ) ) {
        function directorist_is_plugin_active( $plugin ) {
            return in_array( $plugin, (array) get_option( 'active_plugins', array() ), true ) || directorist_is_plugin_active_for_network( $plugin );
        }
    }
    
    if ( ! function_exists( 'directorist_is_plugin_active_for_network' ) ) {
        function directorist_is_plugin_active_for_network( $plugin ) {
            if ( ! is_multisite() ) {
                return false;
            }
                    
            $plugins = get_site_option( 'active_sitewide_plugins' );
            if ( isset( $plugins[ $plugin ] ) ) {
                    return true;
            }
    
            return false;
        }
    }


    /**
     * If the Directorist plugin is activate then Directorist - Coupon plugin is run otherwise don't run.
     */
    if( directorist_is_plugin_active( 'directorist/directorist-base.php' ) ) {
        /**
         * If called this method then Directorist - Coupon Extension is run otherwise don't run
         */
        SWBDPCoupon(); // get the plugin running
    }     
}
