/**
 * @package  Directorist - Coupon
 */

 jQuery(document).ready(function($) {
        /** ************   START Coupon code generator   *************** */
        $('#directorist-coupon-redeem__btn').on('click', function(e) {
                e.preventDefault();
                const plan_id = $('.atbdp-checkout-price-item').attr('name');
                // Get user entired coupon code
                const userCoupCode = $('#directorist-coupon-redeem__code').val();
                const total     = $('#atbdp_checkout_total_amount_hidden').val();
                const tax       = $('#_tax').val();

                const data = {
                        action: 'swbdpc_get_coupons_code',
                        swbdpc_user_coup_code: userCoupCode,
                        plan_id,
                        total,
                        tax,
                };
                $.post(swbdpc_frontend_ajax_object.ajaxurl, data, function(response) {
                        console.log( [response, data] );
                        //return;
                        // Authenticate, is error ccurred or not
                        if (response.error) {
                                $('span#directorist-coupon-redeem__message')
                                        .addClass('directorist-coupon-redeem__message__error')
                                        .text(response.error)
                                        .delay(5000);
                                setTimeout(function() {
                                        $('span#directorist-coupon-redeem__message').text('');
                                }, 6000);

                                return false;
                        }

                        const discount = response.coupInfo.coupAmount;
                        const total = $('#atbdp_checkout_total_amount_hidden').val();
                        const discounted = total - discount;
                        const formattedTotal =  discounted.toFixed(2);
					
					//console.log([discount,totalAmount, grandtotal]);
					
						// format grandtotal
						const options = { 
							  minimumFractionDigits: 2,
							  maximumFractionDigits: 2 
							};
					//   const formattedTotal = Number(grandtotal).toLocaleString('en', options);

                        if (discount) {
                                if (response.coupInfo.success) {
                                        $('span#directorist-coupon-redeem__message')
                                                .addClass('directorist-coupon-redeem__message__success')
                                                .text(response.coupInfo.success)
                                                .delay(5000);
                                        setTimeout(function() {
                                                $('span#directorist-coupon-redeem__message').text('');
                                        }, 6000);
                                }
                                $('#directorist-coupon-redeem__btn').addClass('directorist-coupon-redeem__disabled');
                                $('#atbdp_checkout_total_amount').html(formattedTotal);
                                $('#atbdp_checkout_total_amount_hidden').val(formattedTotal);
                                // For get the coupon id send hedden input field
                                $('#atbdp_pay_notpay_btn').append(response.coupInfo.inputField);
                                $('#atbdp_pay_notpay_btn').append(response.coupInfo.discount_field);
                                $('.atbdp_ch_total_text').after(` <span>${response.coupInfo.discount_text}</span>`);
                        }
                });
        });
        /** ************   END Coupon code generator   *************** */

        const coupon_btn = $('#directorist-coupon-redeem__btn');
        $(coupon_btn).on('click', function() {
                setTimeout(() => {
                        if ($(this).hasClass('directorist-coupon-redeem__disabled')) {
                                $(coupon_btn).off('click');
                        }
                }, 1000);
        });

        /* copy coupon code */
        $('.directorist-coupon__code__copy-btn').each(function(i, e) {
                $(e).on('click', function() {
                        const copyText = $(this).prev('.directorist-coupon__code__text');
                        $(copyText).select();
                        document.execCommand('copy');
                        $(this)
                                .siblings('.directorist-coupon__code__copy-notice').fadeIn().show();
                        setTimeout(() => {
                                $(this)
                                        .siblings('.directorist-coupon__code__copy-notice').fadeOut().hide();
                        }, 2000);
                });
        });

        /* coupon countdown */
        // const countDownWrapper = $('.swbdpc-coupon-countdown');
        const countDownWrapper = [];
        $(countDownWrapper).each(function(i, e) {
                const dateInput = $(e)
                        .siblings('.directorist-coupon__countdown__data')
                        .text();
                const countDownDate = new Date(dateInput).getTime();
                var x = setInterval(function() {
                        const now = new Date().getTime();
                        const distance = countDownDate - now;

                        const days = Math.floor(distance / (1000 * 60 * 60 * 24));
                        const hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
                        const minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
                        const seconds = Math.floor((distance % (1000 * 60)) / 1000);

                        $(e).html(`
        <ul class="directorist-coupon__timer">
                <li>${days} <span>D</span></li>
                <li>${hours} <span>H</span></li>
                <li>${minutes} <span>M</span></li>
                <li>${seconds} <span>S</span></li>
        </ul>`);

                        if (distance < 0) {
                                clearInterval(x);
                                $(e).html('EXPIRED');
                        }
                }, 1000);
        });
}); // End of document.ready
