<?php
/**
 * @package  Directorist - Coupon
 */


if( ! class_exists( 'SWBDPCHelperFunctions' ) ){
    /**
     * All helper functions handler class
     */
    class SWBDPCHelperFunctions
    {
        /**
         * Verify valid input fields or not
         * 
         * @return array
         */
        public static function is_secured( $nonce_field, $nonce_action, $post_id )
        {
            $nonce = isset( $_POST[$nonce_field] ) ? $_POST[$nonce_field] : '';

            if( '' == $nonce ){
                return false;
            }

            if( ! wp_verify_nonce( $nonce, $nonce_action ) ){
                return false;
            }

            if( ! current_user_can( 'edit_post', $post_id ) ){
                return false;
            }

            if( wp_is_post_autosave( $post_id ) ){
                return false;
            }

            if( wp_is_post_revision( $post_id ) ){
                return false;
            }

            return true;
        }



        /**
         * calculate coupon amount
         */ 
        public static function get_coupon_discount( $coupon_id, $checkout_total, $plan_id = NULL) {
            $coupon_rate    = (int) get_post_meta( $coupon_id, 'swbdpc_coupon_amount', true );
            $coupon_type    = get_post_meta( $coupon_id, 'swbdpc_coupon_type', true );
            $checkout_total = (int) $checkout_total;

            if( 'percentage_dis' === $coupon_type ){
                $discount = $checkout_total ? ( $coupon_rate * $checkout_total )/100 : 0;
            }

            if( 'fixed_cart_dis' === $coupon_type ){
                $discount =  $checkout_total ? $coupon_rate : 0;
            }

            if( ( 'fixed_product_dis' === $coupon_type ) && !empty( $plan_id ) ) {
                $discount =  $checkout_total ? $coupon_rate : 0;
            }

            return $discount;
        }
        



    }// End class

}