<?php
/**
 * @package  Directorist - Coupon
 */


if( ! class_exists( 'SWBDPCouponHandler' ) ){
    /**
    * Coupon handler class
    */
    class SWBDPCouponHandler
    {
        /**
         * Class constructor
         * Call all hooks which we wanna triger
         */
        public function register() 
        { 
            // Show coupon input field 
            add_action( 'atbdp_before_checkout_table', array( $this, 'swbdpc_coupon_code_input_field' ) );
            // After discount total amount rander hook
            add_filter( 'atbdp_order_amount', array( $this, 'swbdpc_calculate_after_discount_total_amount' ), 10, 2 );

            add_filter( 'directorist_stripe_checkout_session_args', array( $this, 'add_coupon_to_stripe_checkout_session' ), 10, 3 );
            add_filter( 'directorist_stripe_gateway_total', array( $this, 'directorist_stripe_gateway_total' ), 10, 2 );

        }



        /**
         * 
         * @return array
         */

        public function directorist_stripe_gateway_total( $total, $order_id )
        {   

            
            $discount       = isset( $_POST['discount'] ) ? $_POST['discount'] : 0;
            
            if ( ! empty( $discount ) ) {
                $total = $total + (float) $discount;
            }
            
            return $total;
        }

        /**
         * 
         * @return array
         */

        public function add_coupon_to_stripe_checkout_session( $session_args, $order_id, $apiKey )
        {   

            $stripe_clint   = new \Stripe\StripeClient( $apiKey );
            $discount       = isset( $_POST['discount'] ) ? $_POST['discount'] : 0;
            $currency       = get_directorist_option('payment_currency', get_directorist_option('g_currency', 'usd'));
            
            if ( ! empty( $discount ) ) {
                try {
                    $coupon = $stripe_clint->coupons->create(
                        [ 
                            'duration'      => 'forever',
                            'amount_off'    => $discount * 100,
                            'currency'      => $currency,
                        ]
                      );
    
                      $session_args['discounts'] = [
                            [
                              'coupon' => $coupon->id,
                            ]
                        ];
                    
                } catch ( Exception $e ) {
                    echo "<div class='directorist-alert directorist-alert-danger'>{$e->getMessage()}</div>";
                    return;
                }
            }

            return $session_args;
        }

        /**
         * This function contain coupon code input field
         * 
         * @return void
         */
        public function swbdpc_coupon_code_input_field()
        {           
            $coup_in_field_file_path = SWBDPC_PLUGIN_TEMPLATES_DIR . 'coupon-input-field.php';
            if( file_exists( $coup_in_field_file_path ) ){
                // Require coupon input field template
                include $coup_in_field_file_path;
            }
        }



        /**
         * Calculate after discount the total amount
         * 
         * @return amount
         */
        public function swbdpc_calculate_after_discount_total_amount( $amount, $order_id )
        {      
                 
            $coup_id    = isset( $_POST['swbdpc_coup_id'] ) ? (int)$_POST['swbdpc_coup_id'] : 0;
            $price      = isset( $_POST['price'] ) ? $_POST['price'] : 0;
            $discount   = isset( $_POST['discount'] ) ? $_POST['discount'] : 0;
            
            $listing_id             = get_post_meta( $order_id, '_listing_id', true );
            $plan_from_order        = get_post_meta( $order_id, '_fm_plan_ordered', true );
            $plan_from_listing      = get_post_meta( $listing_id, '_fm_plans', true );
            $plan                   = !empty( $plan_from_order ) ? $plan_from_order : $plan_from_listing;
            $plan_tax               = atpp_total_tax( $plan );
            if( $plan_tax ){
                $amount = (float)$amount + (float)$plan_tax;
            }

            if( ! empty( $coup_id ) && ! empty( $discount ) ){
               
                update_post_meta( $order_id, '_discount', $discount );
                update_post_meta( $order_id, '_coupon', $coup_id );

                // Get current user id
                $user_id = get_current_user_id();              

                $this->update_coupon_uses( $coup_id, $user_id );

                $amount = atbdp_format_payment_amount( $price );
            }

            return $amount;
        }

        private function update_coupon_uses( $coupon_id, $user_id ) {
            $user_data = get_user_meta( $user_id, 'swbdpc_coupon_usages', true ); 
            $coupon_data = get_post_meta( $user_id, 'swbdpc_current_user_count', true );

            $user_data = $user_data ? $user_data : [];
            $coupon_data = $coupon_data ? $coupon_data : [];

            //update user data
            if( $user_data && is_array( $user_data ) ) {
                foreach( $user_data as $coupon => $value ) {
                    if( $coupon_id == $coupon ) {
                       $user_data[$coupon_id] = (int)$value + 1;
                    }
                }
            }else{
                $user_data[$coupon_id] = 1;
            }

            //update coupone data
            if( $coupon_data && is_array( $coupon_data ) ) {
                foreach( $coupon_data as $coupon => $value ) {
                    if( $user_id == $coupon ) {
                       $coupon_data[$user_id] = (int)$value + 1;
                    }
                }
            }else{
                $coupon_data[$user_id] = 1;
            }

            update_user_meta( $user_id, 'swbdpc_coupon_usages', $user_data );
            update_post_meta( $coupon_id, 'swbdpc_current_user_count', $coupon_data );

        }
        
    }// End class
}