<?php
/**
 * @package  Directorist - Coupon
 */

 
if( ! class_exists( 'SWBDPCAjaxHandler' ) ){
    /**
    * Ajax handler class
    */
    class SWBDPCAjaxHandler
    {
        /**
         * Class constructor
         * Call all hooks which we wanna triger
         */
        public function register()
        {
            // Coupon validator hook
            add_action( 'wp_ajax_swbdpc_get_coupons_code', array( $this, 'swbdpc_get_coupons_code' ) );
            add_action( 'wp_ajax_nopriv_swbdpc_get_coupons_code', array( $this, 'swbdpc_get_coupons_code' ) );

            // Hook remover
            add_action( 'plugins_loaded', array( $this, 'swbdpc_hook_remover' ) );
        }



        /**
         * Ajax result transfer function
         *
         * @return void
         */
        public static function swbdpc_get_coupons_code()
        {   
            $c_position = get_directorist_option('payment_currency_position');
            $currency   = atbdp_get_payment_currency();
            $symbol     = atbdp_currency_symbol( $currency );
            $before = '';
            $after = '';
            ('after' == $c_position) ? $after = $symbol : $before = $symbol;
            $errors = array();
            $user_coup_code = isset( $_POST['swbdpc_user_coup_code'] ) ? $_POST['swbdpc_user_coup_code'] : '';
            $plan_id = isset( $_POST['plan_id'] ) ? $_POST['plan_id'] : '';
            $total = isset( $_POST['total'] ) ? $_POST['total'] : '';
            $tax = isset( $_POST['tax'] ) ? $_POST['tax'] : '';
            $total = ! empty( $tax ) ? (int)$total - (int)$tax : $total;


            // Authenticate, coupon input field empty or not
            if( empty( $user_coup_code ) ){
                $errors[ 'errorEmptyCoupCode' ] = __( 'Please enter coupon code!', 'directorist-coupon');                
            }

            $args = array(
                'post_type'         => SWBDPC_POST_TYPE,
                'post_status'       => 'publish',
                'posts_per_page'    => 1,
                'meta_query'        => array(
                    array(
                        'key'       => 'swbdpc_coupon_code',
                        'value'     => $user_coup_code,
                        'compare'   => '=',
                    )
                )
            );
            $coup_details = new WP_Query( $args );
            
            // Authenticate, coupon code exists or not
            if( ! empty( $user_coup_code ) && !$coup_details->have_posts() ){
                $errors[ 'errorInvalidCoup' ] = __( 'Invalid coupon code!', 'directorist-coupon');                
            }

            $coup_info = array();
            if( $coup_details->have_posts() ){
                while( $coup_details->have_posts() ){
                    $coup_details->the_post();

                    $coup_id            = get_the_ID();
                    $user_id            = get_current_user_id();
                    $user_coupon_usages = get_user_meta( $user_id, 'swbdpc_coupon_usages', true );
                    $coup_code          = get_post_meta( $coup_id, 'swbdpc_coupon_code', true );
                    $products           = get_post_meta( $coup_id, 'swbdpc_fixed_products', true );
                    $coup_usage_lim     = get_post_meta( $coup_id, 'swbdpc_coupon_usage_limit', true );
                    $coup_expire_date   = get_post_meta( $coup_id, 'swbdpc_coupon_expiry', true );
                    $coup_type          = get_post_meta( $coup_id, 'swbdpc_coupon_type', true );
                    $fixed_products     = get_post_meta( $coup_id, 'swbdpc_fixed_products', true );

                    $current_usage_count    = get_post_meta( $coup_id, 'swbdpc_current_usage_count', true );
                    //$current_user_count     = get_post_meta( $coup_id, 'swbdpc_current_user_count', true );
                    
                    $current_usage_count    = isset( $current_usage_count ) ? $current_usage_count : 0;
                    //$current_user_count     = isset( $current_user_count ) ? $current_user_count : 0;

                    if( ! empty( $plan_id ) && ! in_array( $plan_id, $products ) ){
						$errors[ 'errorInvalidCoup' ] = __( 'This coupon is not applicable for this plan!', 'directorist-coupon');                
					}
                    
                    $products           = isset( $products ) ? $products : '';
                    $plan_id            = in_array( $plan_id, $products ) ? $plan_id : '';
                    $coup_code          = isset( $coup_code ) ? $coup_code : '';
                    $coup_usage_lim     = isset( $coup_usage_lim ) ? $coup_usage_lim : '';
                    $coup_expire_date   = isset( $coup_expire_date ) ? $coup_expire_date : '';
                    $coup_type          = isset( $coup_type ) ? $coup_type : '';
                    $fixed_products     = isset( $fixed_products ) ? $fixed_products : array();

                    //$user_selected_products = SWBDPCouponHandler::swbdpc_get_product( '');
                    $discount = SWBDPCHelperFunctions::get_coupon_discount( $coup_id, $total, $plan_id );
                    // Authenticate, is Ad expire?
                    if( ! empty( $coup_expire_date ) ){ 
                        $current_date   = date( "Y-m-d" );                        
                        if( $coup_expire_date < $current_date ){                       
                            $errors[ 'errorCoupExpire' ] = __( 'Expired coupon!', 'directorist-coupon');
                        }
                    }

                    if( is_array( $user_coupon_usages ) ) {
                        $user_coupon_usages = ! empty( $user_coupon_usages[$coup_id] ) ? $user_coupon_usages[$coup_id] : 0;
                    }
                    // Authenticate, is usage limit over?
                    if( $coup_usage_lim <= $user_coupon_usages ){
                        // If coupon's date expire then display this massage
                        $errors[ 'errorCoupUsageLimOver' ] = __( 'Coupon usage limit over!', 'directorist-coupon');                        
                    }
                    $input_field = "<input type='hidden' name='swbdpc_coup_id' value='{$coup_id}'>";
                    $discount_field = "<input type='hidden' name='discount' value='{$discount}'>";

                    $coup_info = array(
                        'success'       => __( 'Successfully applied!', 'directorist-coupon' ),
                        'coupId'        => $coup_id,
                        'coupCode'      => $coup_code,
                        'coupAmount'    =>  number_format( $discount, 2 ),
                        'inputField'    => $input_field,
                        'discount_field' => $discount_field,
                        'discount_text' => sprintf( __( 'Total discounted %s', 'directorist-coupon' ), $before . number_format( $discount, 2 ) . $after ),
                    );
                    
                }// End while loop
                wp_reset_postdata();
            }// End if statement

            $error = '';
            foreach( $errors as $error ){
                if( !empty( $error ) ){
                    $error = $error;
                }
            }            
            
            $coup_data = array(
                'coupInfo'  => $coup_info,
                'error'     => $error,
            );

            wp_send_json( $coup_data );
            die();            
        }



        /**
         * Remove hooks when Coupon is disable
         */
        public function swbdpc_hook_remover()
        {
            // Get Coupon enable option
            $is_coupon_enable = get_directorist_option( 'swbdp_coupon_is_enable', 1 );

            // Authenticate, is Coupon enable or not
            if( 1 !== ( int )$is_coupon_enable ){
                remove_action( 'wp_ajax_swbdpc_get_coupons_code', array( $this, 'swbdpc_get_coupons_code' ) );
                remove_action( 'wp_ajax_nopriv_swbdpc_get_coupons_code', array( $this, 'swbdpc_get_coupons_code' ) ); 
                
            }
        }
        
    }// End class
}