<?php

use Directorist_Job_Manager\Helper;

$quick_info    = Helper::get_single_listing_quick_info_data( get_the_ID() );
$salary        = isset( $instance['salary'] ) ? $instance['salary'] : '';
$job_type      = isset( $instance['job_type'] ) ? $instance['job_type'] : '';
$open_position = isset( $instance['open_position'] ) ? $instance['open_position'] : '';
$location      = isset( $instance['location'] ) ? $instance['location'] : '';
$deadline      = isset( $instance['deadline'] ) ? $instance['deadline'] : '';
$website       = isset( $instance['website'] ) ? $instance['website'] : '';

echo $args['before_widget'];

if ( ! empty( $instance['title'] ) ) {
	echo $args['before_title'] . apply_filters( 'widget_title', $instance['title'] ) . $args['after_title'];
}

echo "<ul class='directorist-job-quickinfo-list'>";

// Output generated fields
if ( $salary && $quick_info['dirjob_salary'] ) {
	printf( '<li>%s <strong class="directorist-job-quickinfo-label">%s:</strong> <span class="directorist-job-quickinfo-text"> %s</span></li>', 
	Helper::get_svg_icon( 'money-bill-wave-solid' ), 
	$quick_info['dirjob_salary_label'], 
	$quick_info['dirjob_salary'] );
}
if ( $job_type  && $quick_info['dirjob_job_type'] ) {
	printf( '<li>%s <strong class="directorist-job-quickinfo-label">%s:</strong> <span class="directorist-job-quickinfo-text"> %s</span></li>', 
	Helper::get_svg_icon( 'briefcase-solid' ), 
	$quick_info['dirjob_job_type_label'], 
	$quick_info['dirjob_job_type'] );
}
if ( $open_position && $quick_info['dirjob_open_position'] ) {
	$label_placement = Helper::open_position_label_placement( get_the_ID() );

	if ( 'before' == $label_placement ) {
		printf( '<li>%s <strong class="directorist-job-quickinfo-label">%s</strong> <span class="directorist-job-quickinfo-text"> %s %s</span></li>', Helper::get_svg_icon( 'user-check-solid' ), __( 'Position:', 'directorist-job-manager' ), $quick_info['dirjob_open_position_label'], $quick_info['dirjob_open_position'] );
	} else {
		printf( '<li>%s <strong class="directorist-job-quickinfo-label">%s</strong> <span class="directorist-job-quickinfo-text"> %s %s</span></li>', Helper::get_svg_icon( 'user-check-solid' ), __( 'Position:', 'directorist-job-manager' ), $quick_info['dirjob_open_position'], $quick_info['dirjob_open_position_label'] );
	}
}
if ( $location && $quick_info['address'] ) {
	printf( '<li>%s <strong class="directorist-job-quickinfo-label">%s:</strong> <span class="directorist-job-quickinfo-text"> %s</span></li>', Helper::get_svg_icon( 'map-marker-solid' ), $quick_info['address_label'], $quick_info['address'] );
}
if ( $deadline && $quick_info['dirjob_deadline'] ) {
	printf( '<li>%s <strong class="directorist-job-quickinfo-label">%s:</strong> <span class="directorist-job-quickinfo-text"> %s</span></li>', Helper::get_svg_icon( 'clock' ), $quick_info['dirjob_deadline_label'], esc_html( Helper::get_date_by_wp_format( $quick_info['dirjob_deadline'] ) ) );
}

echo "</ul>";

if ( $website && $quick_info['website'] ) {
	printf( '<a class="directorist-job-quickinfo-link" href="%s"> %s</a>', $quick_info['website'], $quick_info['website'] );
}

echo $args['after_widget'];